# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230831


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ComplianceDetailResource(object):
    """
    Details of the Resource
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ComplianceDetailResource object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param resource_id:
            The value to assign to the resource_id property of this ComplianceDetailResource.
        :type resource_id: str

        :param resource_name:
            The value to assign to the resource_name property of this ComplianceDetailResource.
        :type resource_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ComplianceDetailResource.
        :type compartment_id: str

        :param compartment:
            The value to assign to the compartment property of this ComplianceDetailResource.
        :type compartment: str

        :param resource_region:
            The value to assign to the resource_region property of this ComplianceDetailResource.
        :type resource_region: str

        """
        self.swagger_types = {
            'resource_id': 'str',
            'resource_name': 'str',
            'compartment_id': 'str',
            'compartment': 'str',
            'resource_region': 'str'
        }

        self.attribute_map = {
            'resource_id': 'resourceId',
            'resource_name': 'resourceName',
            'compartment_id': 'compartmentId',
            'compartment': 'compartment',
            'resource_region': 'resourceRegion'
        }

        self._resource_id = None
        self._resource_name = None
        self._compartment_id = None
        self._compartment = None
        self._resource_region = None

    @property
    def resource_id(self):
        """
        **[Required]** Gets the resource_id of this ComplianceDetailResource.
        The OCID to identify the resource.


        :return: The resource_id of this ComplianceDetailResource.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this ComplianceDetailResource.
        The OCID to identify the resource.


        :param resource_id: The resource_id of this ComplianceDetailResource.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def resource_name(self):
        """
        **[Required]** Gets the resource_name of this ComplianceDetailResource.
        Name of the resource.


        :return: The resource_name of this ComplianceDetailResource.
        :rtype: str
        """
        return self._resource_name

    @resource_name.setter
    def resource_name(self, resource_name):
        """
        Sets the resource_name of this ComplianceDetailResource.
        Name of the resource.


        :param resource_name: The resource_name of this ComplianceDetailResource.
        :type: str
        """
        self._resource_name = resource_name

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this ComplianceDetailResource.
        TenancyId of the resource.


        :return: The compartment_id of this ComplianceDetailResource.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ComplianceDetailResource.
        TenancyId of the resource.


        :param compartment_id: The compartment_id of this ComplianceDetailResource.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def compartment(self):
        """
        Gets the compartment of this ComplianceDetailResource.
        Compartment the resource belongs to.


        :return: The compartment of this ComplianceDetailResource.
        :rtype: str
        """
        return self._compartment

    @compartment.setter
    def compartment(self, compartment):
        """
        Sets the compartment of this ComplianceDetailResource.
        Compartment the resource belongs to.


        :param compartment: The compartment of this ComplianceDetailResource.
        :type: str
        """
        self._compartment = compartment

    @property
    def resource_region(self):
        """
        Gets the resource_region of this ComplianceDetailResource.
        Region the resource belongs to.


        :return: The resource_region of this ComplianceDetailResource.
        :rtype: str
        """
        return self._resource_region

    @resource_region.setter
    def resource_region(self, resource_region):
        """
        Sets the resource_region of this ComplianceDetailResource.
        Region the resource belongs to.


        :param resource_region: The resource_region of this ComplianceDetailResource.
        :type: str
        """
        self._resource_region = resource_region

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
