# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230831


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ComplianceDetailPolicy(object):
    """
    Details of the Policy associated
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ComplianceDetailPolicy object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compliance_policy_id:
            The value to assign to the compliance_policy_id property of this ComplianceDetailPolicy.
        :type compliance_policy_id: str

        :param compliance_policy_display_name:
            The value to assign to the compliance_policy_display_name property of this ComplianceDetailPolicy.
        :type compliance_policy_display_name: str

        :param compliance_policy_rule_id:
            The value to assign to the compliance_policy_rule_id property of this ComplianceDetailPolicy.
        :type compliance_policy_rule_id: str

        :param compliance_policy_rule_display_name:
            The value to assign to the compliance_policy_rule_display_name property of this ComplianceDetailPolicy.
        :type compliance_policy_rule_display_name: str

        :param grace_period:
            The value to assign to the grace_period property of this ComplianceDetailPolicy.
        :type grace_period: str

        :param patch_selection:
            The value to assign to the patch_selection property of this ComplianceDetailPolicy.
        :type patch_selection: oci.fleet_apps_management.models.PatchSelectionDetails

        """
        self.swagger_types = {
            'compliance_policy_id': 'str',
            'compliance_policy_display_name': 'str',
            'compliance_policy_rule_id': 'str',
            'compliance_policy_rule_display_name': 'str',
            'grace_period': 'str',
            'patch_selection': 'PatchSelectionDetails'
        }

        self.attribute_map = {
            'compliance_policy_id': 'compliancePolicyId',
            'compliance_policy_display_name': 'compliancePolicyDisplayName',
            'compliance_policy_rule_id': 'compliancePolicyRuleId',
            'compliance_policy_rule_display_name': 'compliancePolicyRuleDisplayName',
            'grace_period': 'gracePeriod',
            'patch_selection': 'patchSelection'
        }

        self._compliance_policy_id = None
        self._compliance_policy_display_name = None
        self._compliance_policy_rule_id = None
        self._compliance_policy_rule_display_name = None
        self._grace_period = None
        self._patch_selection = None

    @property
    def compliance_policy_id(self):
        """
        **[Required]** Gets the compliance_policy_id of this ComplianceDetailPolicy.
        Compliance Policy Id


        :return: The compliance_policy_id of this ComplianceDetailPolicy.
        :rtype: str
        """
        return self._compliance_policy_id

    @compliance_policy_id.setter
    def compliance_policy_id(self, compliance_policy_id):
        """
        Sets the compliance_policy_id of this ComplianceDetailPolicy.
        Compliance Policy Id


        :param compliance_policy_id: The compliance_policy_id of this ComplianceDetailPolicy.
        :type: str
        """
        self._compliance_policy_id = compliance_policy_id

    @property
    def compliance_policy_display_name(self):
        """
        Gets the compliance_policy_display_name of this ComplianceDetailPolicy.
        Compliane Policy DisplayName


        :return: The compliance_policy_display_name of this ComplianceDetailPolicy.
        :rtype: str
        """
        return self._compliance_policy_display_name

    @compliance_policy_display_name.setter
    def compliance_policy_display_name(self, compliance_policy_display_name):
        """
        Sets the compliance_policy_display_name of this ComplianceDetailPolicy.
        Compliane Policy DisplayName


        :param compliance_policy_display_name: The compliance_policy_display_name of this ComplianceDetailPolicy.
        :type: str
        """
        self._compliance_policy_display_name = compliance_policy_display_name

    @property
    def compliance_policy_rule_id(self):
        """
        Gets the compliance_policy_rule_id of this ComplianceDetailPolicy.
        Compliane Policy Rule Id


        :return: The compliance_policy_rule_id of this ComplianceDetailPolicy.
        :rtype: str
        """
        return self._compliance_policy_rule_id

    @compliance_policy_rule_id.setter
    def compliance_policy_rule_id(self, compliance_policy_rule_id):
        """
        Sets the compliance_policy_rule_id of this ComplianceDetailPolicy.
        Compliane Policy Rule Id


        :param compliance_policy_rule_id: The compliance_policy_rule_id of this ComplianceDetailPolicy.
        :type: str
        """
        self._compliance_policy_rule_id = compliance_policy_rule_id

    @property
    def compliance_policy_rule_display_name(self):
        """
        Gets the compliance_policy_rule_display_name of this ComplianceDetailPolicy.
        Product Name


        :return: The compliance_policy_rule_display_name of this ComplianceDetailPolicy.
        :rtype: str
        """
        return self._compliance_policy_rule_display_name

    @compliance_policy_rule_display_name.setter
    def compliance_policy_rule_display_name(self, compliance_policy_rule_display_name):
        """
        Sets the compliance_policy_rule_display_name of this ComplianceDetailPolicy.
        Product Name


        :param compliance_policy_rule_display_name: The compliance_policy_rule_display_name of this ComplianceDetailPolicy.
        :type: str
        """
        self._compliance_policy_rule_display_name = compliance_policy_rule_display_name

    @property
    def grace_period(self):
        """
        Gets the grace_period of this ComplianceDetailPolicy.
        Grace period in days,weeks,months or years the exemption is applicable for the rule.


        :return: The grace_period of this ComplianceDetailPolicy.
        :rtype: str
        """
        return self._grace_period

    @grace_period.setter
    def grace_period(self, grace_period):
        """
        Sets the grace_period of this ComplianceDetailPolicy.
        Grace period in days,weeks,months or years the exemption is applicable for the rule.


        :param grace_period: The grace_period of this ComplianceDetailPolicy.
        :type: str
        """
        self._grace_period = grace_period

    @property
    def patch_selection(self):
        """
        Gets the patch_selection of this ComplianceDetailPolicy.

        :return: The patch_selection of this ComplianceDetailPolicy.
        :rtype: oci.fleet_apps_management.models.PatchSelectionDetails
        """
        return self._patch_selection

    @patch_selection.setter
    def patch_selection(self, patch_selection):
        """
        Sets the patch_selection of this ComplianceDetailPolicy.

        :param patch_selection: The patch_selection of this ComplianceDetailPolicy.
        :type: oci.fleet_apps_management.models.PatchSelectionDetails
        """
        self._patch_selection = patch_selection

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
