# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230831


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Associations(object):
    """
    Associations for the runbook.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Associations object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param tasks:
            The value to assign to the tasks property of this Associations.
        :type tasks: list[oci.fleet_apps_management.models.Task]

        :param groups:
            The value to assign to the groups property of this Associations.
        :type groups: list[oci.fleet_apps_management.models.Group]

        :param execution_workflow_details:
            The value to assign to the execution_workflow_details property of this Associations.
        :type execution_workflow_details: oci.fleet_apps_management.models.ExecutionWorkflowDetails

        :param rollback_workflow_details:
            The value to assign to the rollback_workflow_details property of this Associations.
        :type rollback_workflow_details: oci.fleet_apps_management.models.RollbackWorkflowDetails

        :param version:
            The value to assign to the version property of this Associations.
        :type version: str

        """
        self.swagger_types = {
            'tasks': 'list[Task]',
            'groups': 'list[Group]',
            'execution_workflow_details': 'ExecutionWorkflowDetails',
            'rollback_workflow_details': 'RollbackWorkflowDetails',
            'version': 'str'
        }

        self.attribute_map = {
            'tasks': 'tasks',
            'groups': 'groups',
            'execution_workflow_details': 'executionWorkflowDetails',
            'rollback_workflow_details': 'rollbackWorkflowDetails',
            'version': 'version'
        }

        self._tasks = None
        self._groups = None
        self._execution_workflow_details = None
        self._rollback_workflow_details = None
        self._version = None

    @property
    def tasks(self):
        """
        **[Required]** Gets the tasks of this Associations.
        A set of tasks to execute in the runbook.


        :return: The tasks of this Associations.
        :rtype: list[oci.fleet_apps_management.models.Task]
        """
        return self._tasks

    @tasks.setter
    def tasks(self, tasks):
        """
        Sets the tasks of this Associations.
        A set of tasks to execute in the runbook.


        :param tasks: The tasks of this Associations.
        :type: list[oci.fleet_apps_management.models.Task]
        """
        self._tasks = tasks

    @property
    def groups(self):
        """
        **[Required]** Gets the groups of this Associations.
        The groups of the runbook.


        :return: The groups of this Associations.
        :rtype: list[oci.fleet_apps_management.models.Group]
        """
        return self._groups

    @groups.setter
    def groups(self, groups):
        """
        Sets the groups of this Associations.
        The groups of the runbook.


        :param groups: The groups of this Associations.
        :type: list[oci.fleet_apps_management.models.Group]
        """
        self._groups = groups

    @property
    def execution_workflow_details(self):
        """
        **[Required]** Gets the execution_workflow_details of this Associations.

        :return: The execution_workflow_details of this Associations.
        :rtype: oci.fleet_apps_management.models.ExecutionWorkflowDetails
        """
        return self._execution_workflow_details

    @execution_workflow_details.setter
    def execution_workflow_details(self, execution_workflow_details):
        """
        Sets the execution_workflow_details of this Associations.

        :param execution_workflow_details: The execution_workflow_details of this Associations.
        :type: oci.fleet_apps_management.models.ExecutionWorkflowDetails
        """
        self._execution_workflow_details = execution_workflow_details

    @property
    def rollback_workflow_details(self):
        """
        Gets the rollback_workflow_details of this Associations.

        :return: The rollback_workflow_details of this Associations.
        :rtype: oci.fleet_apps_management.models.RollbackWorkflowDetails
        """
        return self._rollback_workflow_details

    @rollback_workflow_details.setter
    def rollback_workflow_details(self, rollback_workflow_details):
        """
        Sets the rollback_workflow_details of this Associations.

        :param rollback_workflow_details: The rollback_workflow_details of this Associations.
        :type: oci.fleet_apps_management.models.RollbackWorkflowDetails
        """
        self._rollback_workflow_details = rollback_workflow_details

    @property
    def version(self):
        """
        Gets the version of this Associations.
        The version of the runbook.


        :return: The version of this Associations.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this Associations.
        The version of the runbook.


        :param version: The version of this Associations.
        :type: str
        """
        self._version = version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
