# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230831

from .associated_task_details import AssociatedTaskDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AssociatedSharedTaskDetails(AssociatedTaskDetails):
    """
    The details of the shared task.
    Tasks that are part of the task library and can be reused across runbooks.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AssociatedSharedTaskDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.AssociatedSharedTaskDetails.scope` attribute
        of this class is ``SHARED`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param scope:
            The value to assign to the scope property of this AssociatedSharedTaskDetails.
            Allowed values for this property are: "LOCAL", "SHARED"
        :type scope: str

        :param task_record_id:
            The value to assign to the task_record_id property of this AssociatedSharedTaskDetails.
        :type task_record_id: str

        """
        self.swagger_types = {
            'scope': 'str',
            'task_record_id': 'str'
        }

        self.attribute_map = {
            'scope': 'scope',
            'task_record_id': 'taskRecordId'
        }

        self._scope = None
        self._task_record_id = None
        self._scope = 'SHARED'

    @property
    def task_record_id(self):
        """
        **[Required]** Gets the task_record_id of this AssociatedSharedTaskDetails.
        The ID of taskRecord.


        :return: The task_record_id of this AssociatedSharedTaskDetails.
        :rtype: str
        """
        return self._task_record_id

    @task_record_id.setter
    def task_record_id(self, task_record_id):
        """
        Sets the task_record_id of this AssociatedSharedTaskDetails.
        The ID of taskRecord.


        :param task_record_id: The task_record_id of this AssociatedSharedTaskDetails.
        :type: str
        """
        self._task_record_id = task_record_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
