# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230831


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AssociatedFleetPropertyDetails(object):
    """
    The information about associated FleetProperty.
    """

    #: A constant which can be used with the fleet_property_type property of a AssociatedFleetPropertyDetails.
    #: This constant has a value of "STRING"
    FLEET_PROPERTY_TYPE_STRING = "STRING"

    #: A constant which can be used with the fleet_property_type property of a AssociatedFleetPropertyDetails.
    #: This constant has a value of "NUMBER"
    FLEET_PROPERTY_TYPE_NUMBER = "NUMBER"

    def __init__(self, **kwargs):
        """
        Initializes a new AssociatedFleetPropertyDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this AssociatedFleetPropertyDetails.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this AssociatedFleetPropertyDetails.
        :type display_name: str

        :param fleet_property_type:
            The value to assign to the fleet_property_type property of this AssociatedFleetPropertyDetails.
            Allowed values for this property are: "STRING", "NUMBER", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type fleet_property_type: str

        :param value:
            The value to assign to the value property of this AssociatedFleetPropertyDetails.
        :type value: str

        :param is_required:
            The value to assign to the is_required property of this AssociatedFleetPropertyDetails.
        :type is_required: bool

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'display_name': 'str',
            'fleet_property_type': 'str',
            'value': 'str',
            'is_required': 'bool'
        }

        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'fleet_property_type': 'fleetPropertyType',
            'value': 'value',
            'is_required': 'isRequired'
        }

        self._compartment_id = None
        self._display_name = None
        self._fleet_property_type = None
        self._value = None
        self._is_required = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this AssociatedFleetPropertyDetails.
        Tenancy OCID


        :return: The compartment_id of this AssociatedFleetPropertyDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this AssociatedFleetPropertyDetails.
        Tenancy OCID


        :param compartment_id: The compartment_id of this AssociatedFleetPropertyDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        Gets the display_name of this AssociatedFleetPropertyDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :return: The display_name of this AssociatedFleetPropertyDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this AssociatedFleetPropertyDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :param display_name: The display_name of this AssociatedFleetPropertyDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def fleet_property_type(self):
        """
        **[Required]** Gets the fleet_property_type of this AssociatedFleetPropertyDetails.
        Type of the FleetProperty.

        Allowed values for this property are: "STRING", "NUMBER", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The fleet_property_type of this AssociatedFleetPropertyDetails.
        :rtype: str
        """
        return self._fleet_property_type

    @fleet_property_type.setter
    def fleet_property_type(self, fleet_property_type):
        """
        Sets the fleet_property_type of this AssociatedFleetPropertyDetails.
        Type of the FleetProperty.


        :param fleet_property_type: The fleet_property_type of this AssociatedFleetPropertyDetails.
        :type: str
        """
        allowed_values = ["STRING", "NUMBER"]
        if not value_allowed_none_or_none_sentinel(fleet_property_type, allowed_values):
            fleet_property_type = 'UNKNOWN_ENUM_VALUE'
        self._fleet_property_type = fleet_property_type

    @property
    def value(self):
        """
        Gets the value of this AssociatedFleetPropertyDetails.
        Value of the Property.


        :return: The value of this AssociatedFleetPropertyDetails.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this AssociatedFleetPropertyDetails.
        Value of the Property.


        :param value: The value of this AssociatedFleetPropertyDetails.
        :type: str
        """
        self._value = value

    @property
    def is_required(self):
        """
        Gets the is_required of this AssociatedFleetPropertyDetails.
        Property is required or not.


        :return: The is_required of this AssociatedFleetPropertyDetails.
        :rtype: bool
        """
        return self._is_required

    @is_required.setter
    def is_required(self, is_required):
        """
        Sets the is_required of this AssociatedFleetPropertyDetails.
        Property is required or not.


        :param is_required: The is_required of this AssociatedFleetPropertyDetails.
        :type: bool
        """
        self._is_required = is_required

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
