# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125

from .update_dr_protection_group_member_details import UpdateDrProtectionGroupMemberDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateDrProtectionGroupMemberObjectStorageBucketDetails(UpdateDrProtectionGroupMemberDetails):
    """
    Update properties for a object storage bucket member.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateDrProtectionGroupMemberObjectStorageBucketDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.disaster_recovery.models.UpdateDrProtectionGroupMemberObjectStorageBucketDetails.member_type` attribute
        of this class is ``OBJECT_STORAGE_BUCKET`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param member_id:
            The value to assign to the member_id property of this UpdateDrProtectionGroupMemberObjectStorageBucketDetails.
        :type member_id: str

        :param member_type:
            The value to assign to the member_type property of this UpdateDrProtectionGroupMemberObjectStorageBucketDetails.
            Allowed values for this property are: "COMPUTE_INSTANCE", "COMPUTE_INSTANCE_MOVABLE", "COMPUTE_INSTANCE_NON_MOVABLE", "VOLUME_GROUP", "DATABASE", "AUTONOMOUS_DATABASE", "AUTONOMOUS_CONTAINER_DATABASE", "LOAD_BALANCER", "NETWORK_LOAD_BALANCER", "FILE_SYSTEM", "OBJECT_STORAGE_BUCKET"
        :type member_type: str

        :param namespace_name:
            The value to assign to the namespace_name property of this UpdateDrProtectionGroupMemberObjectStorageBucketDetails.
        :type namespace_name: str

        :param bucket_name:
            The value to assign to the bucket_name property of this UpdateDrProtectionGroupMemberObjectStorageBucketDetails.
        :type bucket_name: str

        """
        self.swagger_types = {
            'member_id': 'str',
            'member_type': 'str',
            'namespace_name': 'str',
            'bucket_name': 'str'
        }

        self.attribute_map = {
            'member_id': 'memberId',
            'member_type': 'memberType',
            'namespace_name': 'namespaceName',
            'bucket_name': 'bucketName'
        }

        self._member_id = None
        self._member_type = None
        self._namespace_name = None
        self._bucket_name = None
        self._member_type = 'OBJECT_STORAGE_BUCKET'

    @property
    def namespace_name(self):
        """
        **[Required]** Gets the namespace_name of this UpdateDrProtectionGroupMemberObjectStorageBucketDetails.
        The namespace in object storage (Note - this is usually the tenancy name).

        Example: `myocitenancy`


        :return: The namespace_name of this UpdateDrProtectionGroupMemberObjectStorageBucketDetails.
        :rtype: str
        """
        return self._namespace_name

    @namespace_name.setter
    def namespace_name(self, namespace_name):
        """
        Sets the namespace_name of this UpdateDrProtectionGroupMemberObjectStorageBucketDetails.
        The namespace in object storage (Note - this is usually the tenancy name).

        Example: `myocitenancy`


        :param namespace_name: The namespace_name of this UpdateDrProtectionGroupMemberObjectStorageBucketDetails.
        :type: str
        """
        self._namespace_name = namespace_name

    @property
    def bucket_name(self):
        """
        **[Required]** Gets the bucket_name of this UpdateDrProtectionGroupMemberObjectStorageBucketDetails.
        The bucket name inside the object storage namespace.

        Example: `bucket_name`


        :return: The bucket_name of this UpdateDrProtectionGroupMemberObjectStorageBucketDetails.
        :rtype: str
        """
        return self._bucket_name

    @bucket_name.setter
    def bucket_name(self, bucket_name):
        """
        Sets the bucket_name of this UpdateDrProtectionGroupMemberObjectStorageBucketDetails.
        The bucket name inside the object storage namespace.

        Example: `bucket_name`


        :param bucket_name: The bucket_name of this UpdateDrProtectionGroupMemberObjectStorageBucketDetails.
        :type: str
        """
        self._bucket_name = bucket_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
