# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ReviewPullRequestDetails(object):
    """
    Details to submit pull request review
    """

    #: A constant which can be used with the action property of a ReviewPullRequestDetails.
    #: This constant has a value of "APPROVE"
    ACTION_APPROVE = "APPROVE"

    #: A constant which can be used with the action property of a ReviewPullRequestDetails.
    #: This constant has a value of "UNAPPROVE"
    ACTION_UNAPPROVE = "UNAPPROVE"

    def __init__(self, **kwargs):
        """
        Initializes a new ReviewPullRequestDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param action:
            The value to assign to the action property of this ReviewPullRequestDetails.
            Allowed values for this property are: "APPROVE", "UNAPPROVE"
        :type action: str

        """
        self.swagger_types = {
            'action': 'str'
        }

        self.attribute_map = {
            'action': 'action'
        }

        self._action = None

    @property
    def action(self):
        """
        **[Required]** Gets the action of this ReviewPullRequestDetails.
        The review action taken

        Allowed values for this property are: "APPROVE", "UNAPPROVE"


        :return: The action of this ReviewPullRequestDetails.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """
        Sets the action of this ReviewPullRequestDetails.
        The review action taken


        :param action: The action of this ReviewPullRequestDetails.
        :type: str
        """
        allowed_values = ["APPROVE", "UNAPPROVE"]
        if not value_allowed_none_or_none_sentinel(action, allowed_values):
            raise ValueError(
                f"Invalid value for `action`, must be None or one of {allowed_values}"
            )
        self._action = action

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
