# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PullRequestFileChangeSummary(object):
    """
    Entry for description of change on a file.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PullRequestFileChangeSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param change_type:
            The value to assign to the change_type property of this PullRequestFileChangeSummary.
        :type change_type: str

        :param object_type:
            The value to assign to the object_type property of this PullRequestFileChangeSummary.
        :type object_type: str

        :param commit_id:
            The value to assign to the commit_id property of this PullRequestFileChangeSummary.
        :type commit_id: str

        :param old_path:
            The value to assign to the old_path property of this PullRequestFileChangeSummary.
        :type old_path: str

        :param new_path:
            The value to assign to the new_path property of this PullRequestFileChangeSummary.
        :type new_path: str

        :param old_id:
            The value to assign to the old_id property of this PullRequestFileChangeSummary.
        :type old_id: str

        :param new_id:
            The value to assign to the new_id property of this PullRequestFileChangeSummary.
        :type new_id: str

        :param added_lines_count:
            The value to assign to the added_lines_count property of this PullRequestFileChangeSummary.
        :type added_lines_count: int

        :param deleted_lines_count:
            The value to assign to the deleted_lines_count property of this PullRequestFileChangeSummary.
        :type deleted_lines_count: int

        :param has_conflicts:
            The value to assign to the has_conflicts property of this PullRequestFileChangeSummary.
        :type has_conflicts: bool

        :param freeform_tags:
            The value to assign to the freeform_tags property of this PullRequestFileChangeSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this PullRequestFileChangeSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this PullRequestFileChangeSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'change_type': 'str',
            'object_type': 'str',
            'commit_id': 'str',
            'old_path': 'str',
            'new_path': 'str',
            'old_id': 'str',
            'new_id': 'str',
            'added_lines_count': 'int',
            'deleted_lines_count': 'int',
            'has_conflicts': 'bool',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'change_type': 'changeType',
            'object_type': 'objectType',
            'commit_id': 'commitId',
            'old_path': 'oldPath',
            'new_path': 'newPath',
            'old_id': 'oldId',
            'new_id': 'newId',
            'added_lines_count': 'addedLinesCount',
            'deleted_lines_count': 'deletedLinesCount',
            'has_conflicts': 'hasConflicts',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }

        self._change_type = None
        self._object_type = None
        self._commit_id = None
        self._old_path = None
        self._new_path = None
        self._old_id = None
        self._new_id = None
        self._added_lines_count = None
        self._deleted_lines_count = None
        self._has_conflicts = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def change_type(self):
        """
        **[Required]** Gets the change_type of this PullRequestFileChangeSummary.
        Type of change made to file.


        :return: The change_type of this PullRequestFileChangeSummary.
        :rtype: str
        """
        return self._change_type

    @change_type.setter
    def change_type(self, change_type):
        """
        Sets the change_type of this PullRequestFileChangeSummary.
        Type of change made to file.


        :param change_type: The change_type of this PullRequestFileChangeSummary.
        :type: str
        """
        self._change_type = change_type

    @property
    def object_type(self):
        """
        Gets the object_type of this PullRequestFileChangeSummary.
        The type of the changed object.


        :return: The object_type of this PullRequestFileChangeSummary.
        :rtype: str
        """
        return self._object_type

    @object_type.setter
    def object_type(self, object_type):
        """
        Sets the object_type of this PullRequestFileChangeSummary.
        The type of the changed object.


        :param object_type: The object_type of this PullRequestFileChangeSummary.
        :type: str
        """
        self._object_type = object_type

    @property
    def commit_id(self):
        """
        Gets the commit_id of this PullRequestFileChangeSummary.
        The ID of the commit where the change is coming from.


        :return: The commit_id of this PullRequestFileChangeSummary.
        :rtype: str
        """
        return self._commit_id

    @commit_id.setter
    def commit_id(self, commit_id):
        """
        Sets the commit_id of this PullRequestFileChangeSummary.
        The ID of the commit where the change is coming from.


        :param commit_id: The commit_id of this PullRequestFileChangeSummary.
        :type: str
        """
        self._commit_id = commit_id

    @property
    def old_path(self):
        """
        Gets the old_path of this PullRequestFileChangeSummary.
        The path on the target to the changed object.


        :return: The old_path of this PullRequestFileChangeSummary.
        :rtype: str
        """
        return self._old_path

    @old_path.setter
    def old_path(self, old_path):
        """
        Sets the old_path of this PullRequestFileChangeSummary.
        The path on the target to the changed object.


        :param old_path: The old_path of this PullRequestFileChangeSummary.
        :type: str
        """
        self._old_path = old_path

    @property
    def new_path(self):
        """
        Gets the new_path of this PullRequestFileChangeSummary.
        The path on the source to the changed object.


        :return: The new_path of this PullRequestFileChangeSummary.
        :rtype: str
        """
        return self._new_path

    @new_path.setter
    def new_path(self, new_path):
        """
        Sets the new_path of this PullRequestFileChangeSummary.
        The path on the source to the changed object.


        :param new_path: The new_path of this PullRequestFileChangeSummary.
        :type: str
        """
        self._new_path = new_path

    @property
    def old_id(self):
        """
        Gets the old_id of this PullRequestFileChangeSummary.
        The ID of the changed object on the target.


        :return: The old_id of this PullRequestFileChangeSummary.
        :rtype: str
        """
        return self._old_id

    @old_id.setter
    def old_id(self, old_id):
        """
        Sets the old_id of this PullRequestFileChangeSummary.
        The ID of the changed object on the target.


        :param old_id: The old_id of this PullRequestFileChangeSummary.
        :type: str
        """
        self._old_id = old_id

    @property
    def new_id(self):
        """
        Gets the new_id of this PullRequestFileChangeSummary.
        The ID of the changed object on the source.


        :return: The new_id of this PullRequestFileChangeSummary.
        :rtype: str
        """
        return self._new_id

    @new_id.setter
    def new_id(self, new_id):
        """
        Sets the new_id of this PullRequestFileChangeSummary.
        The ID of the changed object on the source.


        :param new_id: The new_id of this PullRequestFileChangeSummary.
        :type: str
        """
        self._new_id = new_id

    @property
    def added_lines_count(self):
        """
        Gets the added_lines_count of this PullRequestFileChangeSummary.
        The number of lines added in whole difference.


        :return: The added_lines_count of this PullRequestFileChangeSummary.
        :rtype: int
        """
        return self._added_lines_count

    @added_lines_count.setter
    def added_lines_count(self, added_lines_count):
        """
        Sets the added_lines_count of this PullRequestFileChangeSummary.
        The number of lines added in whole difference.


        :param added_lines_count: The added_lines_count of this PullRequestFileChangeSummary.
        :type: int
        """
        self._added_lines_count = added_lines_count

    @property
    def deleted_lines_count(self):
        """
        Gets the deleted_lines_count of this PullRequestFileChangeSummary.
        The number of lines deleted in whole difference.


        :return: The deleted_lines_count of this PullRequestFileChangeSummary.
        :rtype: int
        """
        return self._deleted_lines_count

    @deleted_lines_count.setter
    def deleted_lines_count(self, deleted_lines_count):
        """
        Sets the deleted_lines_count of this PullRequestFileChangeSummary.
        The number of lines deleted in whole difference.


        :param deleted_lines_count: The deleted_lines_count of this PullRequestFileChangeSummary.
        :type: int
        """
        self._deleted_lines_count = deleted_lines_count

    @property
    def has_conflicts(self):
        """
        Gets the has_conflicts of this PullRequestFileChangeSummary.
        Indicates whether the changed file contains conflicts.


        :return: The has_conflicts of this PullRequestFileChangeSummary.
        :rtype: bool
        """
        return self._has_conflicts

    @has_conflicts.setter
    def has_conflicts(self, has_conflicts):
        """
        Sets the has_conflicts of this PullRequestFileChangeSummary.
        Indicates whether the changed file contains conflicts.


        :param has_conflicts: The has_conflicts of this PullRequestFileChangeSummary.
        :type: bool
        """
        self._has_conflicts = has_conflicts

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this PullRequestFileChangeSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See `Resource Tags`__. Example: `{\"bar-key\": \"value\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this PullRequestFileChangeSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this PullRequestFileChangeSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See `Resource Tags`__. Example: `{\"bar-key\": \"value\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this PullRequestFileChangeSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this PullRequestFileChangeSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this PullRequestFileChangeSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this PullRequestFileChangeSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this PullRequestFileChangeSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this PullRequestFileChangeSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces. See `Resource Tags`__. Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The system_tags of this PullRequestFileChangeSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this PullRequestFileChangeSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces. See `Resource Tags`__. Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param system_tags: The system_tags of this PullRequestFileChangeSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
