# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PullRequestActivitySummary(object):
    """
    Summary of an activity record in a pull request
    """

    #: A constant which can be used with the activity_type property of a PullRequestActivitySummary.
    #: This constant has a value of "LIFECYCLE"
    ACTIVITY_TYPE_LIFECYCLE = "LIFECYCLE"

    #: A constant which can be used with the activity_type property of a PullRequestActivitySummary.
    #: This constant has a value of "APPROVAL"
    ACTIVITY_TYPE_APPROVAL = "APPROVAL"

    #: A constant which can be used with the activity_type property of a PullRequestActivitySummary.
    #: This constant has a value of "COMMIT"
    ACTIVITY_TYPE_COMMIT = "COMMIT"

    #: A constant which can be used with the activity_type property of a PullRequestActivitySummary.
    #: This constant has a value of "REVIEWER"
    ACTIVITY_TYPE_REVIEWER = "REVIEWER"

    #: A constant which can be used with the activity_type property of a PullRequestActivitySummary.
    #: This constant has a value of "COMMENT"
    ACTIVITY_TYPE_COMMENT = "COMMENT"

    def __init__(self, **kwargs):
        """
        Initializes a new PullRequestActivitySummary object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.devops.models.CommitActivitySummary`
        * :class:`~oci.devops.models.CommentActivitySummary`
        * :class:`~oci.devops.models.ApprovalActivitySummary`
        * :class:`~oci.devops.models.ReviewerActivitySummary`
        * :class:`~oci.devops.models.PullRequestLifecycleActivitySummary`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this PullRequestActivitySummary.
        :type id: str

        :param principal:
            The value to assign to the principal property of this PullRequestActivitySummary.
        :type principal: oci.devops.models.PrincipalDetails

        :param pull_request_id:
            The value to assign to the pull_request_id property of this PullRequestActivitySummary.
        :type pull_request_id: str

        :param time_occurred:
            The value to assign to the time_occurred property of this PullRequestActivitySummary.
        :type time_occurred: datetime

        :param activity_type:
            The value to assign to the activity_type property of this PullRequestActivitySummary.
            Allowed values for this property are: "LIFECYCLE", "APPROVAL", "COMMIT", "REVIEWER", "COMMENT", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type activity_type: str

        """
        self.swagger_types = {
            'id': 'str',
            'principal': 'PrincipalDetails',
            'pull_request_id': 'str',
            'time_occurred': 'datetime',
            'activity_type': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'principal': 'principal',
            'pull_request_id': 'pullRequestId',
            'time_occurred': 'timeOccurred',
            'activity_type': 'activityType'
        }

        self._id = None
        self._principal = None
        self._pull_request_id = None
        self._time_occurred = None
        self._activity_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['activityType']

        if type == 'COMMIT':
            return 'CommitActivitySummary'

        if type == 'COMMENT':
            return 'CommentActivitySummary'

        if type == 'APPROVAL':
            return 'ApprovalActivitySummary'

        if type == 'REVIEWER':
            return 'ReviewerActivitySummary'

        if type == 'LIFECYCLE':
            return 'PullRequestLifecycleActivitySummary'
        else:
            return 'PullRequestActivitySummary'

    @property
    def id(self):
        """
        **[Required]** Gets the id of this PullRequestActivitySummary.
        activity identifier


        :return: The id of this PullRequestActivitySummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this PullRequestActivitySummary.
        activity identifier


        :param id: The id of this PullRequestActivitySummary.
        :type: str
        """
        self._id = id

    @property
    def principal(self):
        """
        **[Required]** Gets the principal of this PullRequestActivitySummary.

        :return: The principal of this PullRequestActivitySummary.
        :rtype: oci.devops.models.PrincipalDetails
        """
        return self._principal

    @principal.setter
    def principal(self, principal):
        """
        Sets the principal of this PullRequestActivitySummary.

        :param principal: The principal of this PullRequestActivitySummary.
        :type: oci.devops.models.PrincipalDetails
        """
        self._principal = principal

    @property
    def pull_request_id(self):
        """
        **[Required]** Gets the pull_request_id of this PullRequestActivitySummary.
        pullRequest OCID


        :return: The pull_request_id of this PullRequestActivitySummary.
        :rtype: str
        """
        return self._pull_request_id

    @pull_request_id.setter
    def pull_request_id(self, pull_request_id):
        """
        Sets the pull_request_id of this PullRequestActivitySummary.
        pullRequest OCID


        :param pull_request_id: The pull_request_id of this PullRequestActivitySummary.
        :type: str
        """
        self._pull_request_id = pull_request_id

    @property
    def time_occurred(self):
        """
        **[Required]** Gets the time_occurred of this PullRequestActivitySummary.
        The time the action was performed. An RFC3339 formatted datetime string


        :return: The time_occurred of this PullRequestActivitySummary.
        :rtype: datetime
        """
        return self._time_occurred

    @time_occurred.setter
    def time_occurred(self, time_occurred):
        """
        Sets the time_occurred of this PullRequestActivitySummary.
        The time the action was performed. An RFC3339 formatted datetime string


        :param time_occurred: The time_occurred of this PullRequestActivitySummary.
        :type: datetime
        """
        self._time_occurred = time_occurred

    @property
    def activity_type(self):
        """
        **[Required]** Gets the activity_type of this PullRequestActivitySummary.
        The type of activity performed

        Allowed values for this property are: "LIFECYCLE", "APPROVAL", "COMMIT", "REVIEWER", "COMMENT", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The activity_type of this PullRequestActivitySummary.
        :rtype: str
        """
        return self._activity_type

    @activity_type.setter
    def activity_type(self, activity_type):
        """
        Sets the activity_type of this PullRequestActivitySummary.
        The type of activity performed


        :param activity_type: The activity_type of this PullRequestActivitySummary.
        :type: str
        """
        allowed_values = ["LIFECYCLE", "APPROVAL", "COMMIT", "REVIEWER", "COMMENT"]
        if not value_allowed_none_or_none_sentinel(activity_type, allowed_values):
            activity_type = 'UNKNOWN_ENUM_VALUE'
        self._activity_type = activity_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
