# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DeleteGitRefDetails(object):
    """
    The information needed to delete a reference.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DeleteGitRefDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param ref_name:
            The value to assign to the ref_name property of this DeleteGitRefDetails.
        :type ref_name: str

        """
        self.swagger_types = {
            'ref_name': 'str'
        }

        self.attribute_map = {
            'ref_name': 'refName'
        }

        self._ref_name = None

    @property
    def ref_name(self):
        """
        **[Required]** Gets the ref_name of this DeleteGitRefDetails.
        A filter to return only resources that match the given reference name.


        :return: The ref_name of this DeleteGitRefDetails.
        :rtype: str
        """
        return self._ref_name

    @ref_name.setter
    def ref_name(self, ref_name):
        """
        Sets the ref_name of this DeleteGitRefDetails.
        A filter to return only resources that match the given reference name.


        :param ref_name: The ref_name of this DeleteGitRefDetails.
        :type: str
        """
        self._ref_name = ref_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
