# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ApprovalRule(object):
    """
    A rule which must be satisfied for matching pull requests before the pull request can be merged
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ApprovalRule object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this ApprovalRule.
        :type name: str

        :param destination_branch:
            The value to assign to the destination_branch property of this ApprovalRule.
        :type destination_branch: str

        :param reviewers:
            The value to assign to the reviewers property of this ApprovalRule.
        :type reviewers: list[oci.devops.models.PrincipalDetails]

        :param min_approvals_count:
            The value to assign to the min_approvals_count property of this ApprovalRule.
        :type min_approvals_count: int

        """
        self.swagger_types = {
            'name': 'str',
            'destination_branch': 'str',
            'reviewers': 'list[PrincipalDetails]',
            'min_approvals_count': 'int'
        }

        self.attribute_map = {
            'name': 'name',
            'destination_branch': 'destinationBranch',
            'reviewers': 'reviewers',
            'min_approvals_count': 'minApprovalsCount'
        }

        self._name = None
        self._destination_branch = None
        self._reviewers = None
        self._min_approvals_count = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this ApprovalRule.
        Name which is used to uniquely identify an approval rule.


        :return: The name of this ApprovalRule.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ApprovalRule.
        Name which is used to uniquely identify an approval rule.


        :param name: The name of this ApprovalRule.
        :type: str
        """
        self._name = name

    @property
    def destination_branch(self):
        """
        Gets the destination_branch of this ApprovalRule.
        Branch name where pull requests targeting the branch must satisfy the approval rule. This value being null means the rule applies to all pull requests


        :return: The destination_branch of this ApprovalRule.
        :rtype: str
        """
        return self._destination_branch

    @destination_branch.setter
    def destination_branch(self, destination_branch):
        """
        Sets the destination_branch of this ApprovalRule.
        Branch name where pull requests targeting the branch must satisfy the approval rule. This value being null means the rule applies to all pull requests


        :param destination_branch: The destination_branch of this ApprovalRule.
        :type: str
        """
        self._destination_branch = destination_branch

    @property
    def reviewers(self):
        """
        Gets the reviewers of this ApprovalRule.
        List of users who must provide approvals up to the minApprovalsCount specified in the rule. An empty list means the approvals can come from any user.


        :return: The reviewers of this ApprovalRule.
        :rtype: list[oci.devops.models.PrincipalDetails]
        """
        return self._reviewers

    @reviewers.setter
    def reviewers(self, reviewers):
        """
        Sets the reviewers of this ApprovalRule.
        List of users who must provide approvals up to the minApprovalsCount specified in the rule. An empty list means the approvals can come from any user.


        :param reviewers: The reviewers of this ApprovalRule.
        :type: list[oci.devops.models.PrincipalDetails]
        """
        self._reviewers = reviewers

    @property
    def min_approvals_count(self):
        """
        **[Required]** Gets the min_approvals_count of this ApprovalRule.
        Minimum number of approvals which must be provided by the reviewers specified in the list before the rule can be satisfied


        :return: The min_approvals_count of this ApprovalRule.
        :rtype: int
        """
        return self._min_approvals_count

    @min_approvals_count.setter
    def min_approvals_count(self, min_approvals_count):
        """
        Sets the min_approvals_count of this ApprovalRule.
        Minimum number of approvals which must be provided by the reviewers specified in the list before the rule can be satisfied


        :param min_approvals_count: The min_approvals_count of this ApprovalRule.
        :type: int
        """
        self._min_approvals_count = min_approvals_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
