# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateOracleInitialLoadSettings(object):
    """
    Optional settings for Data Pump Export and Import jobs
    """

    #: A constant which can be used with the job_mode property of a UpdateOracleInitialLoadSettings.
    #: This constant has a value of "FULL"
    JOB_MODE_FULL = "FULL"

    #: A constant which can be used with the job_mode property of a UpdateOracleInitialLoadSettings.
    #: This constant has a value of "SCHEMA"
    JOB_MODE_SCHEMA = "SCHEMA"

    #: A constant which can be used with the job_mode property of a UpdateOracleInitialLoadSettings.
    #: This constant has a value of "TABLE"
    JOB_MODE_TABLE = "TABLE"

    #: A constant which can be used with the job_mode property of a UpdateOracleInitialLoadSettings.
    #: This constant has a value of "TABLESPACE"
    JOB_MODE_TABLESPACE = "TABLESPACE"

    #: A constant which can be used with the job_mode property of a UpdateOracleInitialLoadSettings.
    #: This constant has a value of "TRANSPORTABLE"
    JOB_MODE_TRANSPORTABLE = "TRANSPORTABLE"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateOracleInitialLoadSettings object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param data_pump_parameters:
            The value to assign to the data_pump_parameters property of this UpdateOracleInitialLoadSettings.
        :type data_pump_parameters: oci.database_migration.models.UpdateDataPumpParameters

        :param tablespace_details:
            The value to assign to the tablespace_details property of this UpdateOracleInitialLoadSettings.
        :type tablespace_details: oci.database_migration.models.UpdateTargetTypeTablespaceDetails

        :param export_directory_object:
            The value to assign to the export_directory_object property of this UpdateOracleInitialLoadSettings.
        :type export_directory_object: oci.database_migration.models.UpdateDirectoryObject

        :param import_directory_object:
            The value to assign to the import_directory_object property of this UpdateOracleInitialLoadSettings.
        :type import_directory_object: oci.database_migration.models.UpdateDirectoryObject

        :param job_mode:
            The value to assign to the job_mode property of this UpdateOracleInitialLoadSettings.
            Allowed values for this property are: "FULL", "SCHEMA", "TABLE", "TABLESPACE", "TRANSPORTABLE"
        :type job_mode: str

        :param metadata_remaps:
            The value to assign to the metadata_remaps property of this UpdateOracleInitialLoadSettings.
        :type metadata_remaps: list[oci.database_migration.models.MetadataRemap]

        """
        self.swagger_types = {
            'data_pump_parameters': 'UpdateDataPumpParameters',
            'tablespace_details': 'UpdateTargetTypeTablespaceDetails',
            'export_directory_object': 'UpdateDirectoryObject',
            'import_directory_object': 'UpdateDirectoryObject',
            'job_mode': 'str',
            'metadata_remaps': 'list[MetadataRemap]'
        }

        self.attribute_map = {
            'data_pump_parameters': 'dataPumpParameters',
            'tablespace_details': 'tablespaceDetails',
            'export_directory_object': 'exportDirectoryObject',
            'import_directory_object': 'importDirectoryObject',
            'job_mode': 'jobMode',
            'metadata_remaps': 'metadataRemaps'
        }

        self._data_pump_parameters = None
        self._tablespace_details = None
        self._export_directory_object = None
        self._import_directory_object = None
        self._job_mode = None
        self._metadata_remaps = None

    @property
    def data_pump_parameters(self):
        """
        Gets the data_pump_parameters of this UpdateOracleInitialLoadSettings.

        :return: The data_pump_parameters of this UpdateOracleInitialLoadSettings.
        :rtype: oci.database_migration.models.UpdateDataPumpParameters
        """
        return self._data_pump_parameters

    @data_pump_parameters.setter
    def data_pump_parameters(self, data_pump_parameters):
        """
        Sets the data_pump_parameters of this UpdateOracleInitialLoadSettings.

        :param data_pump_parameters: The data_pump_parameters of this UpdateOracleInitialLoadSettings.
        :type: oci.database_migration.models.UpdateDataPumpParameters
        """
        self._data_pump_parameters = data_pump_parameters

    @property
    def tablespace_details(self):
        """
        Gets the tablespace_details of this UpdateOracleInitialLoadSettings.

        :return: The tablespace_details of this UpdateOracleInitialLoadSettings.
        :rtype: oci.database_migration.models.UpdateTargetTypeTablespaceDetails
        """
        return self._tablespace_details

    @tablespace_details.setter
    def tablespace_details(self, tablespace_details):
        """
        Sets the tablespace_details of this UpdateOracleInitialLoadSettings.

        :param tablespace_details: The tablespace_details of this UpdateOracleInitialLoadSettings.
        :type: oci.database_migration.models.UpdateTargetTypeTablespaceDetails
        """
        self._tablespace_details = tablespace_details

    @property
    def export_directory_object(self):
        """
        Gets the export_directory_object of this UpdateOracleInitialLoadSettings.

        :return: The export_directory_object of this UpdateOracleInitialLoadSettings.
        :rtype: oci.database_migration.models.UpdateDirectoryObject
        """
        return self._export_directory_object

    @export_directory_object.setter
    def export_directory_object(self, export_directory_object):
        """
        Sets the export_directory_object of this UpdateOracleInitialLoadSettings.

        :param export_directory_object: The export_directory_object of this UpdateOracleInitialLoadSettings.
        :type: oci.database_migration.models.UpdateDirectoryObject
        """
        self._export_directory_object = export_directory_object

    @property
    def import_directory_object(self):
        """
        Gets the import_directory_object of this UpdateOracleInitialLoadSettings.

        :return: The import_directory_object of this UpdateOracleInitialLoadSettings.
        :rtype: oci.database_migration.models.UpdateDirectoryObject
        """
        return self._import_directory_object

    @import_directory_object.setter
    def import_directory_object(self, import_directory_object):
        """
        Sets the import_directory_object of this UpdateOracleInitialLoadSettings.

        :param import_directory_object: The import_directory_object of this UpdateOracleInitialLoadSettings.
        :type: oci.database_migration.models.UpdateDirectoryObject
        """
        self._import_directory_object = import_directory_object

    @property
    def job_mode(self):
        """
        **[Required]** Gets the job_mode of this UpdateOracleInitialLoadSettings.
        Oracle Job Mode

        Allowed values for this property are: "FULL", "SCHEMA", "TABLE", "TABLESPACE", "TRANSPORTABLE"


        :return: The job_mode of this UpdateOracleInitialLoadSettings.
        :rtype: str
        """
        return self._job_mode

    @job_mode.setter
    def job_mode(self, job_mode):
        """
        Sets the job_mode of this UpdateOracleInitialLoadSettings.
        Oracle Job Mode


        :param job_mode: The job_mode of this UpdateOracleInitialLoadSettings.
        :type: str
        """
        allowed_values = ["FULL", "SCHEMA", "TABLE", "TABLESPACE", "TRANSPORTABLE"]
        if not value_allowed_none_or_none_sentinel(job_mode, allowed_values):
            raise ValueError(
                f"Invalid value for `job_mode`, must be None or one of {allowed_values}"
            )
        self._job_mode = job_mode

    @property
    def metadata_remaps(self):
        """
        Gets the metadata_remaps of this UpdateOracleInitialLoadSettings.
        Defines remapping to be applied to objects as they are processed.


        :return: The metadata_remaps of this UpdateOracleInitialLoadSettings.
        :rtype: list[oci.database_migration.models.MetadataRemap]
        """
        return self._metadata_remaps

    @metadata_remaps.setter
    def metadata_remaps(self, metadata_remaps):
        """
        Sets the metadata_remaps of this UpdateOracleInitialLoadSettings.
        Defines remapping to be applied to objects as they are processed.


        :param metadata_remaps: The metadata_remaps of this UpdateOracleInitialLoadSettings.
        :type: list[oci.database_migration.models.MetadataRemap]
        """
        self._metadata_remaps = metadata_remaps

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
