# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GgsDeployment(object):
    """
    Details about Oracle GoldenGate GGS Deployment.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GgsDeployment object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param deployment_id:
            The value to assign to the deployment_id property of this GgsDeployment.
        :type deployment_id: str

        :param ggs_admin_credentials_secret_id:
            The value to assign to the ggs_admin_credentials_secret_id property of this GgsDeployment.
        :type ggs_admin_credentials_secret_id: str

        """
        self.swagger_types = {
            'deployment_id': 'str',
            'ggs_admin_credentials_secret_id': 'str'
        }

        self.attribute_map = {
            'deployment_id': 'deploymentId',
            'ggs_admin_credentials_secret_id': 'ggsAdminCredentialsSecretId'
        }

        self._deployment_id = None
        self._ggs_admin_credentials_secret_id = None

    @property
    def deployment_id(self):
        """
        **[Required]** Gets the deployment_id of this GgsDeployment.
        The OCID of the resource being referenced.


        :return: The deployment_id of this GgsDeployment.
        :rtype: str
        """
        return self._deployment_id

    @deployment_id.setter
    def deployment_id(self, deployment_id):
        """
        Sets the deployment_id of this GgsDeployment.
        The OCID of the resource being referenced.


        :param deployment_id: The deployment_id of this GgsDeployment.
        :type: str
        """
        self._deployment_id = deployment_id

    @property
    def ggs_admin_credentials_secret_id(self):
        """
        **[Required]** Gets the ggs_admin_credentials_secret_id of this GgsDeployment.
        The OCID of the resource being referenced.


        :return: The ggs_admin_credentials_secret_id of this GgsDeployment.
        :rtype: str
        """
        return self._ggs_admin_credentials_secret_id

    @ggs_admin_credentials_secret_id.setter
    def ggs_admin_credentials_secret_id(self, ggs_admin_credentials_secret_id):
        """
        Sets the ggs_admin_credentials_secret_id of this GgsDeployment.
        The OCID of the resource being referenced.


        :param ggs_admin_credentials_secret_id: The ggs_admin_credentials_secret_id of this GgsDeployment.
        :type: str
        """
        self._ggs_admin_credentials_secret_id = ggs_admin_credentials_secret_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
