# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Connection(object):
    """
    Represents the common details required for creating a new connection.
    """

    #: A constant which can be used with the connection_type property of a Connection.
    #: This constant has a value of "MYSQL"
    CONNECTION_TYPE_MYSQL = "MYSQL"

    #: A constant which can be used with the connection_type property of a Connection.
    #: This constant has a value of "ORACLE"
    CONNECTION_TYPE_ORACLE = "ORACLE"

    #: A constant which can be used with the lifecycle_state property of a Connection.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a Connection.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a Connection.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a Connection.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a Connection.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a Connection.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a Connection.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new Connection object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.database_migration.models.MysqlConnection`
        * :class:`~oci.database_migration.models.OracleConnection`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param connection_type:
            The value to assign to the connection_type property of this Connection.
            Allowed values for this property are: "MYSQL", "ORACLE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type connection_type: str

        :param id:
            The value to assign to the id property of this Connection.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this Connection.
        :type display_name: str

        :param description:
            The value to assign to the description property of this Connection.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this Connection.
        :type compartment_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this Connection.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this Connection.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this Connection.
        :type system_tags: dict(str, dict(str, object))

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this Connection.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this Connection.
        :type lifecycle_details: str

        :param time_created:
            The value to assign to the time_created property of this Connection.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this Connection.
        :type time_updated: datetime

        :param vault_id:
            The value to assign to the vault_id property of this Connection.
        :type vault_id: str

        :param key_id:
            The value to assign to the key_id property of this Connection.
        :type key_id: str

        :param subnet_id:
            The value to assign to the subnet_id property of this Connection.
        :type subnet_id: str

        :param ingress_ips:
            The value to assign to the ingress_ips property of this Connection.
        :type ingress_ips: list[oci.database_migration.models.IngressIpDetails]

        :param nsg_ids:
            The value to assign to the nsg_ids property of this Connection.
        :type nsg_ids: list[str]

        :param username:
            The value to assign to the username property of this Connection.
        :type username: str

        :param password:
            The value to assign to the password property of this Connection.
        :type password: str

        :param replication_username:
            The value to assign to the replication_username property of this Connection.
        :type replication_username: str

        :param replication_password:
            The value to assign to the replication_password property of this Connection.
        :type replication_password: str

        :param secret_id:
            The value to assign to the secret_id property of this Connection.
        :type secret_id: str

        :param private_endpoint_id:
            The value to assign to the private_endpoint_id property of this Connection.
        :type private_endpoint_id: str

        """
        self.swagger_types = {
            'connection_type': 'str',
            'id': 'str',
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'vault_id': 'str',
            'key_id': 'str',
            'subnet_id': 'str',
            'ingress_ips': 'list[IngressIpDetails]',
            'nsg_ids': 'list[str]',
            'username': 'str',
            'password': 'str',
            'replication_username': 'str',
            'replication_password': 'str',
            'secret_id': 'str',
            'private_endpoint_id': 'str'
        }

        self.attribute_map = {
            'connection_type': 'connectionType',
            'id': 'id',
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'vault_id': 'vaultId',
            'key_id': 'keyId',
            'subnet_id': 'subnetId',
            'ingress_ips': 'ingressIps',
            'nsg_ids': 'nsgIds',
            'username': 'username',
            'password': 'password',
            'replication_username': 'replicationUsername',
            'replication_password': 'replicationPassword',
            'secret_id': 'secretId',
            'private_endpoint_id': 'privateEndpointId'
        }

        self._connection_type = None
        self._id = None
        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._time_created = None
        self._time_updated = None
        self._vault_id = None
        self._key_id = None
        self._subnet_id = None
        self._ingress_ips = None
        self._nsg_ids = None
        self._username = None
        self._password = None
        self._replication_username = None
        self._replication_password = None
        self._secret_id = None
        self._private_endpoint_id = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['connectionType']

        if type == 'MYSQL':
            return 'MysqlConnection'

        if type == 'ORACLE':
            return 'OracleConnection'
        else:
            return 'Connection'

    @property
    def connection_type(self):
        """
        **[Required]** Gets the connection_type of this Connection.
        Defines the type of connection. For example, ORACLE.

        Allowed values for this property are: "MYSQL", "ORACLE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The connection_type of this Connection.
        :rtype: str
        """
        return self._connection_type

    @connection_type.setter
    def connection_type(self, connection_type):
        """
        Sets the connection_type of this Connection.
        Defines the type of connection. For example, ORACLE.


        :param connection_type: The connection_type of this Connection.
        :type: str
        """
        allowed_values = ["MYSQL", "ORACLE"]
        if not value_allowed_none_or_none_sentinel(connection_type, allowed_values):
            connection_type = 'UNKNOWN_ENUM_VALUE'
        self._connection_type = connection_type

    @property
    def id(self):
        """
        **[Required]** Gets the id of this Connection.
        The OCID of the connection being referenced.


        :return: The id of this Connection.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Connection.
        The OCID of the connection being referenced.


        :param id: The id of this Connection.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this Connection.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this Connection.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this Connection.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this Connection.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this Connection.
        A user-friendly description. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The description of this Connection.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Connection.
        A user-friendly description. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param description: The description of this Connection.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this Connection.
        The OCID of the compartment.


        :return: The compartment_id of this Connection.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this Connection.
        The OCID of the compartment.


        :param compartment_id: The compartment_id of this Connection.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this Connection.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see Resource Tags. Example: {\"Department\": \"Finance\"}


        :return: The freeform_tags of this Connection.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this Connection.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see Resource Tags. Example: {\"Department\": \"Finance\"}


        :param freeform_tags: The freeform_tags of this Connection.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this Connection.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this Connection.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this Connection.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this Connection.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this Connection.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this Connection.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this Connection.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this Connection.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this Connection.
        The Connection's current lifecycle state.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this Connection.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this Connection.
        The Connection's current lifecycle state.


        :param lifecycle_state: The lifecycle_state of this Connection.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this Connection.
        The message describing the current state of the connection's lifecycle in detail.
        For example, can be used to provide actionable information for a connection in a Failed state.


        :return: The lifecycle_details of this Connection.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this Connection.
        The message describing the current state of the connection's lifecycle in detail.
        For example, can be used to provide actionable information for a connection in a Failed state.


        :param lifecycle_details: The lifecycle_details of this Connection.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this Connection.
        The time when this resource was created.
        An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.


        :return: The time_created of this Connection.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this Connection.
        The time when this resource was created.
        An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.


        :param time_created: The time_created of this Connection.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this Connection.
        The time when this resource was updated.
        An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.


        :return: The time_updated of this Connection.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this Connection.
        The time when this resource was updated.
        An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.


        :param time_updated: The time_updated of this Connection.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def vault_id(self):
        """
        Gets the vault_id of this Connection.
        OCI resource ID.


        :return: The vault_id of this Connection.
        :rtype: str
        """
        return self._vault_id

    @vault_id.setter
    def vault_id(self, vault_id):
        """
        Sets the vault_id of this Connection.
        OCI resource ID.


        :param vault_id: The vault_id of this Connection.
        :type: str
        """
        self._vault_id = vault_id

    @property
    def key_id(self):
        """
        Gets the key_id of this Connection.
        The OCID of the key used in cryptographic operations.


        :return: The key_id of this Connection.
        :rtype: str
        """
        return self._key_id

    @key_id.setter
    def key_id(self, key_id):
        """
        Sets the key_id of this Connection.
        The OCID of the key used in cryptographic operations.


        :param key_id: The key_id of this Connection.
        :type: str
        """
        self._key_id = key_id

    @property
    def subnet_id(self):
        """
        Gets the subnet_id of this Connection.
        OCI resource ID.


        :return: The subnet_id of this Connection.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this Connection.
        OCI resource ID.


        :param subnet_id: The subnet_id of this Connection.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def ingress_ips(self):
        """
        Gets the ingress_ips of this Connection.
        List of ingress IP addresses from where to connect to this connection's privateIp.


        :return: The ingress_ips of this Connection.
        :rtype: list[oci.database_migration.models.IngressIpDetails]
        """
        return self._ingress_ips

    @ingress_ips.setter
    def ingress_ips(self, ingress_ips):
        """
        Sets the ingress_ips of this Connection.
        List of ingress IP addresses from where to connect to this connection's privateIp.


        :param ingress_ips: The ingress_ips of this Connection.
        :type: list[oci.database_migration.models.IngressIpDetails]
        """
        self._ingress_ips = ingress_ips

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this Connection.
        An array of Network Security Group OCIDs used to define network access for Connections.


        :return: The nsg_ids of this Connection.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this Connection.
        An array of Network Security Group OCIDs used to define network access for Connections.


        :param nsg_ids: The nsg_ids of this Connection.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    @property
    def username(self):
        """
        **[Required]** Gets the username of this Connection.
        The username (credential) used when creating or updating this resource.


        :return: The username of this Connection.
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """
        Sets the username of this Connection.
        The username (credential) used when creating or updating this resource.


        :param username: The username of this Connection.
        :type: str
        """
        self._username = username

    @property
    def password(self):
        """
        Gets the password of this Connection.
        The password (credential) used when creating or updating this resource.


        :return: The password of this Connection.
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """
        Sets the password of this Connection.
        The password (credential) used when creating or updating this resource.


        :param password: The password of this Connection.
        :type: str
        """
        self._password = password

    @property
    def replication_username(self):
        """
        Gets the replication_username of this Connection.
        The username (credential) used when creating or updating this resource.


        :return: The replication_username of this Connection.
        :rtype: str
        """
        return self._replication_username

    @replication_username.setter
    def replication_username(self, replication_username):
        """
        Sets the replication_username of this Connection.
        The username (credential) used when creating or updating this resource.


        :param replication_username: The replication_username of this Connection.
        :type: str
        """
        self._replication_username = replication_username

    @property
    def replication_password(self):
        """
        Gets the replication_password of this Connection.
        The password (credential) used when creating or updating this resource.


        :return: The replication_password of this Connection.
        :rtype: str
        """
        return self._replication_password

    @replication_password.setter
    def replication_password(self, replication_password):
        """
        Sets the replication_password of this Connection.
        The password (credential) used when creating or updating this resource.


        :param replication_password: The replication_password of this Connection.
        :type: str
        """
        self._replication_password = replication_password

    @property
    def secret_id(self):
        """
        Gets the secret_id of this Connection.
        The OCID of the resource being referenced.


        :return: The secret_id of this Connection.
        :rtype: str
        """
        return self._secret_id

    @secret_id.setter
    def secret_id(self, secret_id):
        """
        Sets the secret_id of this Connection.
        The OCID of the resource being referenced.


        :param secret_id: The secret_id of this Connection.
        :type: str
        """
        self._secret_id = secret_id

    @property
    def private_endpoint_id(self):
        """
        Gets the private_endpoint_id of this Connection.
        The OCID of the resource being referenced.


        :return: The private_endpoint_id of this Connection.
        :rtype: str
        """
        return self._private_endpoint_id

    @private_endpoint_id.setter
    def private_endpoint_id(self, private_endpoint_id):
        """
        Sets the private_endpoint_id of this Connection.
        The OCID of the resource being referenced.


        :param private_endpoint_id: The private_endpoint_id of this Connection.
        :type: str
        """
        self._private_endpoint_id = private_endpoint_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
