# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ConnectorDetails(object):
    """
    The connector details required to connect to an Oracle cloud database.
    """

    #: A constant which can be used with the connector_type property of a ConnectorDetails.
    #: This constant has a value of "PE"
    CONNECTOR_TYPE_PE = "PE"

    #: A constant which can be used with the connector_type property of a ConnectorDetails.
    #: This constant has a value of "MACS"
    CONNECTOR_TYPE_MACS = "MACS"

    #: A constant which can be used with the connector_type property of a ConnectorDetails.
    #: This constant has a value of "EXTERNAL"
    CONNECTOR_TYPE_EXTERNAL = "EXTERNAL"

    #: A constant which can be used with the connector_type property of a ConnectorDetails.
    #: This constant has a value of "DIRECT"
    CONNECTOR_TYPE_DIRECT = "DIRECT"

    def __init__(self, **kwargs):
        """
        Initializes a new ConnectorDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.database_management.models.ExternalConnectorDetails`
        * :class:`~oci.database_management.models.DirectConnectorDetails`
        * :class:`~oci.database_management.models.MacsConnectorDetails`
        * :class:`~oci.database_management.models.PrivateEndPointConnectorDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param connector_type:
            The value to assign to the connector_type property of this ConnectorDetails.
            Allowed values for this property are: "PE", "MACS", "EXTERNAL", "DIRECT", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type connector_type: str

        """
        self.swagger_types = {
            'connector_type': 'str'
        }

        self.attribute_map = {
            'connector_type': 'connectorType'
        }

        self._connector_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['connectorType']

        if type == 'EXTERNAL':
            return 'ExternalConnectorDetails'

        if type == 'DIRECT':
            return 'DirectConnectorDetails'

        if type == 'MACS':
            return 'MacsConnectorDetails'

        if type == 'PE':
            return 'PrivateEndPointConnectorDetails'
        else:
            return 'ConnectorDetails'

    @property
    def connector_type(self):
        """
        **[Required]** Gets the connector_type of this ConnectorDetails.
        The list of supported connection types:
          - PE: Private endpoint
          - MACS: Management agent
          - EXTERNAL: External database connector

          - DIRECT: Direct connection

        Allowed values for this property are: "PE", "MACS", "EXTERNAL", "DIRECT", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The connector_type of this ConnectorDetails.
        :rtype: str
        """
        return self._connector_type

    @connector_type.setter
    def connector_type(self, connector_type):
        """
        Sets the connector_type of this ConnectorDetails.
        The list of supported connection types:
          - PE: Private endpoint
          - MACS: Management agent
          - EXTERNAL: External database connector

          - DIRECT: Direct connection


        :param connector_type: The connector_type of this ConnectorDetails.
        :type: str
        """
        allowed_values = ["PE", "MACS", "EXTERNAL", "DIRECT"]
        if not value_allowed_none_or_none_sentinel(connector_type, allowed_values):
            connector_type = 'UNKNOWN_ENUM_VALUE'
        self._connector_type = connector_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
