# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExecutionActionMember(object):
    """
    The action member details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExecutionActionMember object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param member_order:
            The value to assign to the member_order property of this ExecutionActionMember.
        :type member_order: int

        :param member_id:
            The value to assign to the member_id property of this ExecutionActionMember.
        :type member_id: str

        :param status:
            The value to assign to the status property of this ExecutionActionMember.
        :type status: str

        :param estimated_time_in_mins:
            The value to assign to the estimated_time_in_mins property of this ExecutionActionMember.
        :type estimated_time_in_mins: int

        :param total_time_taken_in_mins:
            The value to assign to the total_time_taken_in_mins property of this ExecutionActionMember.
        :type total_time_taken_in_mins: int

        """
        self.swagger_types = {
            'member_order': 'int',
            'member_id': 'str',
            'status': 'str',
            'estimated_time_in_mins': 'int',
            'total_time_taken_in_mins': 'int'
        }

        self.attribute_map = {
            'member_order': 'memberOrder',
            'member_id': 'memberId',
            'status': 'status',
            'estimated_time_in_mins': 'estimatedTimeInMins',
            'total_time_taken_in_mins': 'totalTimeTakenInMins'
        }

        self._member_order = None
        self._member_id = None
        self._status = None
        self._estimated_time_in_mins = None
        self._total_time_taken_in_mins = None

    @property
    def member_order(self):
        """
        **[Required]** Gets the member_order of this ExecutionActionMember.
        The priority order of the execution action member.


        :return: The member_order of this ExecutionActionMember.
        :rtype: int
        """
        return self._member_order

    @member_order.setter
    def member_order(self, member_order):
        """
        Sets the member_order of this ExecutionActionMember.
        The priority order of the execution action member.


        :param member_order: The member_order of this ExecutionActionMember.
        :type: int
        """
        self._member_order = member_order

    @property
    def member_id(self):
        """
        **[Required]** Gets the member_id of this ExecutionActionMember.
        The `OCID`__ of the parent resource the execution action belongs to.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The member_id of this ExecutionActionMember.
        :rtype: str
        """
        return self._member_id

    @member_id.setter
    def member_id(self, member_id):
        """
        Sets the member_id of this ExecutionActionMember.
        The `OCID`__ of the parent resource the execution action belongs to.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param member_id: The member_id of this ExecutionActionMember.
        :type: str
        """
        self._member_id = member_id

    @property
    def status(self):
        """
        Gets the status of this ExecutionActionMember.
        The current status of the execution action member. Valid states are SCHEDULED, IN_PROGRESS, FAILED, CANCELED, DURATION_EXCEEDED, RESCHEDULED and COMPLETED.
        enum:
        - SCHEDULED
        - IN_PROGRESS
        - FAILED
        - CANCELED
        - DURATION_EXCEEDED
        - RESCHEDULED
        - SUCCEEDED


        :return: The status of this ExecutionActionMember.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this ExecutionActionMember.
        The current status of the execution action member. Valid states are SCHEDULED, IN_PROGRESS, FAILED, CANCELED, DURATION_EXCEEDED, RESCHEDULED and COMPLETED.
        enum:
        - SCHEDULED
        - IN_PROGRESS
        - FAILED
        - CANCELED
        - DURATION_EXCEEDED
        - RESCHEDULED
        - SUCCEEDED


        :param status: The status of this ExecutionActionMember.
        :type: str
        """
        self._status = status

    @property
    def estimated_time_in_mins(self):
        """
        Gets the estimated_time_in_mins of this ExecutionActionMember.
        The estimated time of the execution action member in minutes.


        :return: The estimated_time_in_mins of this ExecutionActionMember.
        :rtype: int
        """
        return self._estimated_time_in_mins

    @estimated_time_in_mins.setter
    def estimated_time_in_mins(self, estimated_time_in_mins):
        """
        Sets the estimated_time_in_mins of this ExecutionActionMember.
        The estimated time of the execution action member in minutes.


        :param estimated_time_in_mins: The estimated_time_in_mins of this ExecutionActionMember.
        :type: int
        """
        self._estimated_time_in_mins = estimated_time_in_mins

    @property
    def total_time_taken_in_mins(self):
        """
        Gets the total_time_taken_in_mins of this ExecutionActionMember.
        The total time taken by corresponding resource activity in minutes.


        :return: The total_time_taken_in_mins of this ExecutionActionMember.
        :rtype: int
        """
        return self._total_time_taken_in_mins

    @total_time_taken_in_mins.setter
    def total_time_taken_in_mins(self, total_time_taken_in_mins):
        """
        Sets the total_time_taken_in_mins of this ExecutionActionMember.
        The total time taken by corresponding resource activity in minutes.


        :param total_time_taken_in_mins: The total_time_taken_in_mins of this ExecutionActionMember.
        :type: int
        """
        self._total_time_taken_in_mins = total_time_taken_in_mins

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
