# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DbNode(object):
    """
    DbNode model.
    """

    #: A constant which can be used with the lifecycle_state property of a DbNode.
    #: This constant has a value of "PROVISIONING"
    LIFECYCLE_STATE_PROVISIONING = "PROVISIONING"

    #: A constant which can be used with the lifecycle_state property of a DbNode.
    #: This constant has a value of "AVAILABLE"
    LIFECYCLE_STATE_AVAILABLE = "AVAILABLE"

    #: A constant which can be used with the lifecycle_state property of a DbNode.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a DbNode.
    #: This constant has a value of "STOPPING"
    LIFECYCLE_STATE_STOPPING = "STOPPING"

    #: A constant which can be used with the lifecycle_state property of a DbNode.
    #: This constant has a value of "STOPPED"
    LIFECYCLE_STATE_STOPPED = "STOPPED"

    #: A constant which can be used with the lifecycle_state property of a DbNode.
    #: This constant has a value of "STARTING"
    LIFECYCLE_STATE_STARTING = "STARTING"

    #: A constant which can be used with the lifecycle_state property of a DbNode.
    #: This constant has a value of "TERMINATING"
    LIFECYCLE_STATE_TERMINATING = "TERMINATING"

    #: A constant which can be used with the lifecycle_state property of a DbNode.
    #: This constant has a value of "TERMINATED"
    LIFECYCLE_STATE_TERMINATED = "TERMINATED"

    #: A constant which can be used with the lifecycle_state property of a DbNode.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the maintenance_type property of a DbNode.
    #: This constant has a value of "VMDB_REBOOT_MIGRATION"
    MAINTENANCE_TYPE_VMDB_REBOOT_MIGRATION = "VMDB_REBOOT_MIGRATION"

    #: A constant which can be used with the maintenance_type property of a DbNode.
    #: This constant has a value of "EXADBXS_REBOOT_MIGRATION"
    MAINTENANCE_TYPE_EXADBXS_REBOOT_MIGRATION = "EXADBXS_REBOOT_MIGRATION"

    def __init__(self, **kwargs):
        """
        Initializes a new DbNode object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this DbNode.
        :type id: str

        :param db_system_id:
            The value to assign to the db_system_id property of this DbNode.
        :type db_system_id: str

        :param vnic_id:
            The value to assign to the vnic_id property of this DbNode.
        :type vnic_id: str

        :param backup_vnic_id:
            The value to assign to the backup_vnic_id property of this DbNode.
        :type backup_vnic_id: str

        :param host_ip_id:
            The value to assign to the host_ip_id property of this DbNode.
        :type host_ip_id: str

        :param backup_ip_id:
            The value to assign to the backup_ip_id property of this DbNode.
        :type backup_ip_id: str

        :param vnic2_id:
            The value to assign to the vnic2_id property of this DbNode.
        :type vnic2_id: str

        :param backup_vnic2_id:
            The value to assign to the backup_vnic2_id property of this DbNode.
        :type backup_vnic2_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this DbNode.
            Allowed values for this property are: "PROVISIONING", "AVAILABLE", "UPDATING", "STOPPING", "STOPPED", "STARTING", "TERMINATING", "TERMINATED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param hostname:
            The value to assign to the hostname property of this DbNode.
        :type hostname: str

        :param fault_domain:
            The value to assign to the fault_domain property of this DbNode.
        :type fault_domain: str

        :param time_created:
            The value to assign to the time_created property of this DbNode.
        :type time_created: datetime

        :param software_storage_size_in_gb:
            The value to assign to the software_storage_size_in_gb property of this DbNode.
        :type software_storage_size_in_gb: int

        :param maintenance_type:
            The value to assign to the maintenance_type property of this DbNode.
            Allowed values for this property are: "VMDB_REBOOT_MIGRATION", "EXADBXS_REBOOT_MIGRATION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type maintenance_type: str

        :param time_maintenance_window_start:
            The value to assign to the time_maintenance_window_start property of this DbNode.
        :type time_maintenance_window_start: datetime

        :param time_maintenance_window_end:
            The value to assign to the time_maintenance_window_end property of this DbNode.
        :type time_maintenance_window_end: datetime

        :param additional_details:
            The value to assign to the additional_details property of this DbNode.
        :type additional_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this DbNode.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this DbNode.
        :type defined_tags: dict(str, dict(str, object))

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this DbNode.
        :type lifecycle_details: str

        :param cpu_core_count:
            The value to assign to the cpu_core_count property of this DbNode.
        :type cpu_core_count: int

        :param memory_size_in_gbs:
            The value to assign to the memory_size_in_gbs property of this DbNode.
        :type memory_size_in_gbs: int

        :param db_node_storage_size_in_gbs:
            The value to assign to the db_node_storage_size_in_gbs property of this DbNode.
        :type db_node_storage_size_in_gbs: int

        :param total_cpu_core_count:
            The value to assign to the total_cpu_core_count property of this DbNode.
        :type total_cpu_core_count: int

        :param db_server_id:
            The value to assign to the db_server_id property of this DbNode.
        :type db_server_id: str

        """
        self.swagger_types = {
            'id': 'str',
            'db_system_id': 'str',
            'vnic_id': 'str',
            'backup_vnic_id': 'str',
            'host_ip_id': 'str',
            'backup_ip_id': 'str',
            'vnic2_id': 'str',
            'backup_vnic2_id': 'str',
            'lifecycle_state': 'str',
            'hostname': 'str',
            'fault_domain': 'str',
            'time_created': 'datetime',
            'software_storage_size_in_gb': 'int',
            'maintenance_type': 'str',
            'time_maintenance_window_start': 'datetime',
            'time_maintenance_window_end': 'datetime',
            'additional_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'lifecycle_details': 'str',
            'cpu_core_count': 'int',
            'memory_size_in_gbs': 'int',
            'db_node_storage_size_in_gbs': 'int',
            'total_cpu_core_count': 'int',
            'db_server_id': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'db_system_id': 'dbSystemId',
            'vnic_id': 'vnicId',
            'backup_vnic_id': 'backupVnicId',
            'host_ip_id': 'hostIpId',
            'backup_ip_id': 'backupIpId',
            'vnic2_id': 'vnic2Id',
            'backup_vnic2_id': 'backupVnic2Id',
            'lifecycle_state': 'lifecycleState',
            'hostname': 'hostname',
            'fault_domain': 'faultDomain',
            'time_created': 'timeCreated',
            'software_storage_size_in_gb': 'softwareStorageSizeInGB',
            'maintenance_type': 'maintenanceType',
            'time_maintenance_window_start': 'timeMaintenanceWindowStart',
            'time_maintenance_window_end': 'timeMaintenanceWindowEnd',
            'additional_details': 'additionalDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'lifecycle_details': 'lifecycleDetails',
            'cpu_core_count': 'cpuCoreCount',
            'memory_size_in_gbs': 'memorySizeInGBs',
            'db_node_storage_size_in_gbs': 'dbNodeStorageSizeInGBs',
            'total_cpu_core_count': 'totalCpuCoreCount',
            'db_server_id': 'dbServerId'
        }

        self._id = None
        self._db_system_id = None
        self._vnic_id = None
        self._backup_vnic_id = None
        self._host_ip_id = None
        self._backup_ip_id = None
        self._vnic2_id = None
        self._backup_vnic2_id = None
        self._lifecycle_state = None
        self._hostname = None
        self._fault_domain = None
        self._time_created = None
        self._software_storage_size_in_gb = None
        self._maintenance_type = None
        self._time_maintenance_window_start = None
        self._time_maintenance_window_end = None
        self._additional_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._lifecycle_details = None
        self._cpu_core_count = None
        self._memory_size_in_gbs = None
        self._db_node_storage_size_in_gbs = None
        self._total_cpu_core_count = None
        self._db_server_id = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this DbNode.
        The `OCID`__ of the database node.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this DbNode.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DbNode.
        The `OCID`__ of the database node.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this DbNode.
        :type: str
        """
        self._id = id

    @property
    def db_system_id(self):
        """
        **[Required]** Gets the db_system_id of this DbNode.
        The `OCID`__ of the DB system.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The db_system_id of this DbNode.
        :rtype: str
        """
        return self._db_system_id

    @db_system_id.setter
    def db_system_id(self, db_system_id):
        """
        Sets the db_system_id of this DbNode.
        The `OCID`__ of the DB system.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param db_system_id: The db_system_id of this DbNode.
        :type: str
        """
        self._db_system_id = db_system_id

    @property
    def vnic_id(self):
        """
        **[Required]** Gets the vnic_id of this DbNode.
        The `OCID`__ of the VNIC.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The vnic_id of this DbNode.
        :rtype: str
        """
        return self._vnic_id

    @vnic_id.setter
    def vnic_id(self, vnic_id):
        """
        Sets the vnic_id of this DbNode.
        The `OCID`__ of the VNIC.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param vnic_id: The vnic_id of this DbNode.
        :type: str
        """
        self._vnic_id = vnic_id

    @property
    def backup_vnic_id(self):
        """
        Gets the backup_vnic_id of this DbNode.
        The `OCID`__ of the backup VNIC.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The backup_vnic_id of this DbNode.
        :rtype: str
        """
        return self._backup_vnic_id

    @backup_vnic_id.setter
    def backup_vnic_id(self, backup_vnic_id):
        """
        Sets the backup_vnic_id of this DbNode.
        The `OCID`__ of the backup VNIC.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param backup_vnic_id: The backup_vnic_id of this DbNode.
        :type: str
        """
        self._backup_vnic_id = backup_vnic_id

    @property
    def host_ip_id(self):
        """
        Gets the host_ip_id of this DbNode.
        The `OCID`__ of the host IP address associated with the database node. Use this OCID with either the
        :func:`get_private_ip` or the :func:`get_public_ip_by_private_ip_id` API to get the IP address
        needed to make a database connection.

        **Note:** Applies only to Exadata Cloud Service.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The host_ip_id of this DbNode.
        :rtype: str
        """
        return self._host_ip_id

    @host_ip_id.setter
    def host_ip_id(self, host_ip_id):
        """
        Sets the host_ip_id of this DbNode.
        The `OCID`__ of the host IP address associated with the database node. Use this OCID with either the
        :func:`get_private_ip` or the :func:`get_public_ip_by_private_ip_id` API to get the IP address
        needed to make a database connection.

        **Note:** Applies only to Exadata Cloud Service.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param host_ip_id: The host_ip_id of this DbNode.
        :type: str
        """
        self._host_ip_id = host_ip_id

    @property
    def backup_ip_id(self):
        """
        Gets the backup_ip_id of this DbNode.
        The `OCID`__ of the backup IP address associated with the database node. Use this OCID with either the
        :func:`get_private_ip` or the :func:`get_public_ip_by_private_ip_id` API to get the IP address
        needed to make a database connection.

        **Note:** Applies only to Exadata Cloud Service.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The backup_ip_id of this DbNode.
        :rtype: str
        """
        return self._backup_ip_id

    @backup_ip_id.setter
    def backup_ip_id(self, backup_ip_id):
        """
        Sets the backup_ip_id of this DbNode.
        The `OCID`__ of the backup IP address associated with the database node. Use this OCID with either the
        :func:`get_private_ip` or the :func:`get_public_ip_by_private_ip_id` API to get the IP address
        needed to make a database connection.

        **Note:** Applies only to Exadata Cloud Service.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param backup_ip_id: The backup_ip_id of this DbNode.
        :type: str
        """
        self._backup_ip_id = backup_ip_id

    @property
    def vnic2_id(self):
        """
        Gets the vnic2_id of this DbNode.
        The `OCID`__ of the second VNIC.

        **Note:** Applies only to Exadata Cloud Service.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The vnic2_id of this DbNode.
        :rtype: str
        """
        return self._vnic2_id

    @vnic2_id.setter
    def vnic2_id(self, vnic2_id):
        """
        Sets the vnic2_id of this DbNode.
        The `OCID`__ of the second VNIC.

        **Note:** Applies only to Exadata Cloud Service.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param vnic2_id: The vnic2_id of this DbNode.
        :type: str
        """
        self._vnic2_id = vnic2_id

    @property
    def backup_vnic2_id(self):
        """
        Gets the backup_vnic2_id of this DbNode.
        The `OCID`__ of the second backup VNIC.

        **Note:** Applies only to Exadata Cloud Service.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The backup_vnic2_id of this DbNode.
        :rtype: str
        """
        return self._backup_vnic2_id

    @backup_vnic2_id.setter
    def backup_vnic2_id(self, backup_vnic2_id):
        """
        Sets the backup_vnic2_id of this DbNode.
        The `OCID`__ of the second backup VNIC.

        **Note:** Applies only to Exadata Cloud Service.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param backup_vnic2_id: The backup_vnic2_id of this DbNode.
        :type: str
        """
        self._backup_vnic2_id = backup_vnic2_id

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this DbNode.
        The current state of the database node.

        Allowed values for this property are: "PROVISIONING", "AVAILABLE", "UPDATING", "STOPPING", "STOPPED", "STARTING", "TERMINATING", "TERMINATED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this DbNode.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this DbNode.
        The current state of the database node.


        :param lifecycle_state: The lifecycle_state of this DbNode.
        :type: str
        """
        allowed_values = ["PROVISIONING", "AVAILABLE", "UPDATING", "STOPPING", "STOPPED", "STARTING", "TERMINATING", "TERMINATED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def hostname(self):
        """
        Gets the hostname of this DbNode.
        The host name for the database node.


        :return: The hostname of this DbNode.
        :rtype: str
        """
        return self._hostname

    @hostname.setter
    def hostname(self, hostname):
        """
        Sets the hostname of this DbNode.
        The host name for the database node.


        :param hostname: The hostname of this DbNode.
        :type: str
        """
        self._hostname = hostname

    @property
    def fault_domain(self):
        """
        Gets the fault_domain of this DbNode.
        The name of the Fault Domain the instance is contained in.


        :return: The fault_domain of this DbNode.
        :rtype: str
        """
        return self._fault_domain

    @fault_domain.setter
    def fault_domain(self, fault_domain):
        """
        Sets the fault_domain of this DbNode.
        The name of the Fault Domain the instance is contained in.


        :param fault_domain: The fault_domain of this DbNode.
        :type: str
        """
        self._fault_domain = fault_domain

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this DbNode.
        The date and time that the database node was created.


        :return: The time_created of this DbNode.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this DbNode.
        The date and time that the database node was created.


        :param time_created: The time_created of this DbNode.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def software_storage_size_in_gb(self):
        """
        Gets the software_storage_size_in_gb of this DbNode.
        The size (in GB) of the block storage volume allocation for the DB system. This attribute applies only for virtual machine DB systems.


        :return: The software_storage_size_in_gb of this DbNode.
        :rtype: int
        """
        return self._software_storage_size_in_gb

    @software_storage_size_in_gb.setter
    def software_storage_size_in_gb(self, software_storage_size_in_gb):
        """
        Sets the software_storage_size_in_gb of this DbNode.
        The size (in GB) of the block storage volume allocation for the DB system. This attribute applies only for virtual machine DB systems.


        :param software_storage_size_in_gb: The software_storage_size_in_gb of this DbNode.
        :type: int
        """
        self._software_storage_size_in_gb = software_storage_size_in_gb

    @property
    def maintenance_type(self):
        """
        Gets the maintenance_type of this DbNode.
        The type of database node maintenance.

        Allowed values for this property are: "VMDB_REBOOT_MIGRATION", "EXADBXS_REBOOT_MIGRATION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The maintenance_type of this DbNode.
        :rtype: str
        """
        return self._maintenance_type

    @maintenance_type.setter
    def maintenance_type(self, maintenance_type):
        """
        Sets the maintenance_type of this DbNode.
        The type of database node maintenance.


        :param maintenance_type: The maintenance_type of this DbNode.
        :type: str
        """
        allowed_values = ["VMDB_REBOOT_MIGRATION", "EXADBXS_REBOOT_MIGRATION"]
        if not value_allowed_none_or_none_sentinel(maintenance_type, allowed_values):
            maintenance_type = 'UNKNOWN_ENUM_VALUE'
        self._maintenance_type = maintenance_type

    @property
    def time_maintenance_window_start(self):
        """
        Gets the time_maintenance_window_start of this DbNode.
        Start date and time of maintenance window.


        :return: The time_maintenance_window_start of this DbNode.
        :rtype: datetime
        """
        return self._time_maintenance_window_start

    @time_maintenance_window_start.setter
    def time_maintenance_window_start(self, time_maintenance_window_start):
        """
        Sets the time_maintenance_window_start of this DbNode.
        Start date and time of maintenance window.


        :param time_maintenance_window_start: The time_maintenance_window_start of this DbNode.
        :type: datetime
        """
        self._time_maintenance_window_start = time_maintenance_window_start

    @property
    def time_maintenance_window_end(self):
        """
        Gets the time_maintenance_window_end of this DbNode.
        End date and time of maintenance window.


        :return: The time_maintenance_window_end of this DbNode.
        :rtype: datetime
        """
        return self._time_maintenance_window_end

    @time_maintenance_window_end.setter
    def time_maintenance_window_end(self, time_maintenance_window_end):
        """
        Sets the time_maintenance_window_end of this DbNode.
        End date and time of maintenance window.


        :param time_maintenance_window_end: The time_maintenance_window_end of this DbNode.
        :type: datetime
        """
        self._time_maintenance_window_end = time_maintenance_window_end

    @property
    def additional_details(self):
        """
        Gets the additional_details of this DbNode.
        Additional information about the planned maintenance.


        :return: The additional_details of this DbNode.
        :rtype: str
        """
        return self._additional_details

    @additional_details.setter
    def additional_details(self, additional_details):
        """
        Sets the additional_details of this DbNode.
        Additional information about the planned maintenance.


        :param additional_details: The additional_details of this DbNode.
        :type: str
        """
        self._additional_details = additional_details

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this DbNode.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this DbNode.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this DbNode.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this DbNode.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this DbNode.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this DbNode.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this DbNode.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this DbNode.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this DbNode.
        Information about the current lifecycle state.


        :return: The lifecycle_details of this DbNode.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this DbNode.
        Information about the current lifecycle state.


        :param lifecycle_details: The lifecycle_details of this DbNode.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def cpu_core_count(self):
        """
        Gets the cpu_core_count of this DbNode.
        The number of CPU cores enabled on the Db node.


        :return: The cpu_core_count of this DbNode.
        :rtype: int
        """
        return self._cpu_core_count

    @cpu_core_count.setter
    def cpu_core_count(self, cpu_core_count):
        """
        Sets the cpu_core_count of this DbNode.
        The number of CPU cores enabled on the Db node.


        :param cpu_core_count: The cpu_core_count of this DbNode.
        :type: int
        """
        self._cpu_core_count = cpu_core_count

    @property
    def memory_size_in_gbs(self):
        """
        Gets the memory_size_in_gbs of this DbNode.
        The allocated memory in GBs on the Db node.


        :return: The memory_size_in_gbs of this DbNode.
        :rtype: int
        """
        return self._memory_size_in_gbs

    @memory_size_in_gbs.setter
    def memory_size_in_gbs(self, memory_size_in_gbs):
        """
        Sets the memory_size_in_gbs of this DbNode.
        The allocated memory in GBs on the Db node.


        :param memory_size_in_gbs: The memory_size_in_gbs of this DbNode.
        :type: int
        """
        self._memory_size_in_gbs = memory_size_in_gbs

    @property
    def db_node_storage_size_in_gbs(self):
        """
        Gets the db_node_storage_size_in_gbs of this DbNode.
        The allocated local node storage in GBs on the Db node.


        :return: The db_node_storage_size_in_gbs of this DbNode.
        :rtype: int
        """
        return self._db_node_storage_size_in_gbs

    @db_node_storage_size_in_gbs.setter
    def db_node_storage_size_in_gbs(self, db_node_storage_size_in_gbs):
        """
        Sets the db_node_storage_size_in_gbs of this DbNode.
        The allocated local node storage in GBs on the Db node.


        :param db_node_storage_size_in_gbs: The db_node_storage_size_in_gbs of this DbNode.
        :type: int
        """
        self._db_node_storage_size_in_gbs = db_node_storage_size_in_gbs

    @property
    def total_cpu_core_count(self):
        """
        Gets the total_cpu_core_count of this DbNode.
        The total number of CPU cores reserved on the Db node.


        :return: The total_cpu_core_count of this DbNode.
        :rtype: int
        """
        return self._total_cpu_core_count

    @total_cpu_core_count.setter
    def total_cpu_core_count(self, total_cpu_core_count):
        """
        Sets the total_cpu_core_count of this DbNode.
        The total number of CPU cores reserved on the Db node.


        :param total_cpu_core_count: The total_cpu_core_count of this DbNode.
        :type: int
        """
        self._total_cpu_core_count = total_cpu_core_count

    @property
    def db_server_id(self):
        """
        Gets the db_server_id of this DbNode.
        The `OCID`__ of the Exacc Db server associated with the database node.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The db_server_id of this DbNode.
        :rtype: str
        """
        return self._db_server_id

    @db_server_id.setter
    def db_server_id(self, db_server_id):
        """
        Sets the db_server_id of this DbNode.
        The `OCID`__ of the Exacc Db server associated with the database node.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param db_server_id: The db_server_id of this DbNode.
        :type: str
        """
        self._db_server_id = db_server_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
