# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateSchedulingPlanDetails(object):
    """
    Request to create Scheduling Plan.
    """

    #: A constant which can be used with the service_type property of a CreateSchedulingPlanDetails.
    #: This constant has a value of "EXACC"
    SERVICE_TYPE_EXACC = "EXACC"

    #: A constant which can be used with the service_type property of a CreateSchedulingPlanDetails.
    #: This constant has a value of "EXACS"
    SERVICE_TYPE_EXACS = "EXACS"

    #: A constant which can be used with the service_type property of a CreateSchedulingPlanDetails.
    #: This constant has a value of "FPPPCS"
    SERVICE_TYPE_FPPPCS = "FPPPCS"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateSchedulingPlanDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateSchedulingPlanDetails.
        :type compartment_id: str

        :param scheduling_policy_id:
            The value to assign to the scheduling_policy_id property of this CreateSchedulingPlanDetails.
        :type scheduling_policy_id: str

        :param resource_id:
            The value to assign to the resource_id property of this CreateSchedulingPlanDetails.
        :type resource_id: str

        :param service_type:
            The value to assign to the service_type property of this CreateSchedulingPlanDetails.
            Allowed values for this property are: "EXACC", "EXACS", "FPPPCS"
        :type service_type: str

        :param is_using_recommended_scheduled_actions:
            The value to assign to the is_using_recommended_scheduled_actions property of this CreateSchedulingPlanDetails.
        :type is_using_recommended_scheduled_actions: bool

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateSchedulingPlanDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateSchedulingPlanDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'scheduling_policy_id': 'str',
            'resource_id': 'str',
            'service_type': 'str',
            'is_using_recommended_scheduled_actions': 'bool',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'scheduling_policy_id': 'schedulingPolicyId',
            'resource_id': 'resourceId',
            'service_type': 'serviceType',
            'is_using_recommended_scheduled_actions': 'isUsingRecommendedScheduledActions',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._compartment_id = None
        self._scheduling_policy_id = None
        self._resource_id = None
        self._service_type = None
        self._is_using_recommended_scheduled_actions = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateSchedulingPlanDetails.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateSchedulingPlanDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateSchedulingPlanDetails.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateSchedulingPlanDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def scheduling_policy_id(self):
        """
        **[Required]** Gets the scheduling_policy_id of this CreateSchedulingPlanDetails.
        The `OCID`__ of the Scheduling Policy.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The scheduling_policy_id of this CreateSchedulingPlanDetails.
        :rtype: str
        """
        return self._scheduling_policy_id

    @scheduling_policy_id.setter
    def scheduling_policy_id(self, scheduling_policy_id):
        """
        Sets the scheduling_policy_id of this CreateSchedulingPlanDetails.
        The `OCID`__ of the Scheduling Policy.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param scheduling_policy_id: The scheduling_policy_id of this CreateSchedulingPlanDetails.
        :type: str
        """
        self._scheduling_policy_id = scheduling_policy_id

    @property
    def resource_id(self):
        """
        **[Required]** Gets the resource_id of this CreateSchedulingPlanDetails.
        The `OCID`__ of the resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The resource_id of this CreateSchedulingPlanDetails.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this CreateSchedulingPlanDetails.
        The `OCID`__ of the resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param resource_id: The resource_id of this CreateSchedulingPlanDetails.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def service_type(self):
        """
        **[Required]** Gets the service_type of this CreateSchedulingPlanDetails.
        The service type of the Scheduling Plan.

        Allowed values for this property are: "EXACC", "EXACS", "FPPPCS"


        :return: The service_type of this CreateSchedulingPlanDetails.
        :rtype: str
        """
        return self._service_type

    @service_type.setter
    def service_type(self, service_type):
        """
        Sets the service_type of this CreateSchedulingPlanDetails.
        The service type of the Scheduling Plan.


        :param service_type: The service_type of this CreateSchedulingPlanDetails.
        :type: str
        """
        allowed_values = ["EXACC", "EXACS", "FPPPCS"]
        if not value_allowed_none_or_none_sentinel(service_type, allowed_values):
            raise ValueError(
                f"Invalid value for `service_type`, must be None or one of {allowed_values}"
            )
        self._service_type = service_type

    @property
    def is_using_recommended_scheduled_actions(self):
        """
        Gets the is_using_recommended_scheduled_actions of this CreateSchedulingPlanDetails.
        If true, recommended scheduled actions will be generated for the scheduling plan.


        :return: The is_using_recommended_scheduled_actions of this CreateSchedulingPlanDetails.
        :rtype: bool
        """
        return self._is_using_recommended_scheduled_actions

    @is_using_recommended_scheduled_actions.setter
    def is_using_recommended_scheduled_actions(self, is_using_recommended_scheduled_actions):
        """
        Sets the is_using_recommended_scheduled_actions of this CreateSchedulingPlanDetails.
        If true, recommended scheduled actions will be generated for the scheduling plan.


        :param is_using_recommended_scheduled_actions: The is_using_recommended_scheduled_actions of this CreateSchedulingPlanDetails.
        :type: bool
        """
        self._is_using_recommended_scheduled_actions = is_using_recommended_scheduled_actions

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateSchedulingPlanDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateSchedulingPlanDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateSchedulingPlanDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateSchedulingPlanDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateSchedulingPlanDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateSchedulingPlanDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateSchedulingPlanDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateSchedulingPlanDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
