# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateExecutionActionDetails(object):
    """
    Request to create execution action resource.
    """

    #: A constant which can be used with the action_type property of a CreateExecutionActionDetails.
    #: This constant has a value of "DB_SERVER_FULL_SOFTWARE_UPDATE"
    ACTION_TYPE_DB_SERVER_FULL_SOFTWARE_UPDATE = "DB_SERVER_FULL_SOFTWARE_UPDATE"

    #: A constant which can be used with the action_type property of a CreateExecutionActionDetails.
    #: This constant has a value of "STORAGE_SERVER_FULL_SOFTWARE_UPDATE"
    ACTION_TYPE_STORAGE_SERVER_FULL_SOFTWARE_UPDATE = "STORAGE_SERVER_FULL_SOFTWARE_UPDATE"

    #: A constant which can be used with the action_type property of a CreateExecutionActionDetails.
    #: This constant has a value of "NETWORK_SWITCH_FULL_SOFTWARE_UPDATE"
    ACTION_TYPE_NETWORK_SWITCH_FULL_SOFTWARE_UPDATE = "NETWORK_SWITCH_FULL_SOFTWARE_UPDATE"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateExecutionActionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateExecutionActionDetails.
        :type compartment_id: str

        :param execution_window_id:
            The value to assign to the execution_window_id property of this CreateExecutionActionDetails.
        :type execution_window_id: str

        :param action_type:
            The value to assign to the action_type property of this CreateExecutionActionDetails.
            Allowed values for this property are: "DB_SERVER_FULL_SOFTWARE_UPDATE", "STORAGE_SERVER_FULL_SOFTWARE_UPDATE", "NETWORK_SWITCH_FULL_SOFTWARE_UPDATE"
        :type action_type: str

        :param action_params:
            The value to assign to the action_params property of this CreateExecutionActionDetails.
        :type action_params: dict(str, str)

        :param action_members:
            The value to assign to the action_members property of this CreateExecutionActionDetails.
        :type action_members: list[oci.database.models.ExecutionActionMember]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateExecutionActionDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateExecutionActionDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'execution_window_id': 'str',
            'action_type': 'str',
            'action_params': 'dict(str, str)',
            'action_members': 'list[ExecutionActionMember]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'execution_window_id': 'executionWindowId',
            'action_type': 'actionType',
            'action_params': 'actionParams',
            'action_members': 'actionMembers',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._compartment_id = None
        self._execution_window_id = None
        self._action_type = None
        self._action_params = None
        self._action_members = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this CreateExecutionActionDetails.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateExecutionActionDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateExecutionActionDetails.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateExecutionActionDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def execution_window_id(self):
        """
        **[Required]** Gets the execution_window_id of this CreateExecutionActionDetails.
        The `OCID`__ of the execution window resource the execution action belongs to.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The execution_window_id of this CreateExecutionActionDetails.
        :rtype: str
        """
        return self._execution_window_id

    @execution_window_id.setter
    def execution_window_id(self, execution_window_id):
        """
        Sets the execution_window_id of this CreateExecutionActionDetails.
        The `OCID`__ of the execution window resource the execution action belongs to.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param execution_window_id: The execution_window_id of this CreateExecutionActionDetails.
        :type: str
        """
        self._execution_window_id = execution_window_id

    @property
    def action_type(self):
        """
        **[Required]** Gets the action_type of this CreateExecutionActionDetails.
        The action type of the execution action being performed

        Allowed values for this property are: "DB_SERVER_FULL_SOFTWARE_UPDATE", "STORAGE_SERVER_FULL_SOFTWARE_UPDATE", "NETWORK_SWITCH_FULL_SOFTWARE_UPDATE"


        :return: The action_type of this CreateExecutionActionDetails.
        :rtype: str
        """
        return self._action_type

    @action_type.setter
    def action_type(self, action_type):
        """
        Sets the action_type of this CreateExecutionActionDetails.
        The action type of the execution action being performed


        :param action_type: The action_type of this CreateExecutionActionDetails.
        :type: str
        """
        allowed_values = ["DB_SERVER_FULL_SOFTWARE_UPDATE", "STORAGE_SERVER_FULL_SOFTWARE_UPDATE", "NETWORK_SWITCH_FULL_SOFTWARE_UPDATE"]
        if not value_allowed_none_or_none_sentinel(action_type, allowed_values):
            raise ValueError(
                f"Invalid value for `action_type`, must be None or one of {allowed_values}"
            )
        self._action_type = action_type

    @property
    def action_params(self):
        """
        Gets the action_params of this CreateExecutionActionDetails.
        Map<ParamName, ParamValue> where a key value pair describes the specific action parameter.
        Example: `{\"count\": \"3\"}`


        :return: The action_params of this CreateExecutionActionDetails.
        :rtype: dict(str, str)
        """
        return self._action_params

    @action_params.setter
    def action_params(self, action_params):
        """
        Sets the action_params of this CreateExecutionActionDetails.
        Map<ParamName, ParamValue> where a key value pair describes the specific action parameter.
        Example: `{\"count\": \"3\"}`


        :param action_params: The action_params of this CreateExecutionActionDetails.
        :type: dict(str, str)
        """
        self._action_params = action_params

    @property
    def action_members(self):
        """
        Gets the action_members of this CreateExecutionActionDetails.
        List of action members of this execution action.


        :return: The action_members of this CreateExecutionActionDetails.
        :rtype: list[oci.database.models.ExecutionActionMember]
        """
        return self._action_members

    @action_members.setter
    def action_members(self, action_members):
        """
        Sets the action_members of this CreateExecutionActionDetails.
        List of action members of this execution action.


        :param action_members: The action_members of this CreateExecutionActionDetails.
        :type: list[oci.database.models.ExecutionActionMember]
        """
        self._action_members = action_members

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateExecutionActionDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateExecutionActionDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateExecutionActionDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateExecutionActionDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateExecutionActionDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateExecutionActionDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateExecutionActionDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateExecutionActionDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
