# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CloudAutomationFreezePeriod(object):
    """
    Enables a freeze period for the VM cluster prohibiting the VMs from getting cloud automation software updates during critical business cycles. Freeze period start date. Starts at 12:00 AM UTC on the selected date and ends at 11:59:59 PM UTC on the selected date. Validates to ensure the freeze period does not exceed 45 days.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CloudAutomationFreezePeriod object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param freeze_period_start_time:
            The value to assign to the freeze_period_start_time property of this CloudAutomationFreezePeriod.
        :type freeze_period_start_time: str

        :param freeze_period_end_time:
            The value to assign to the freeze_period_end_time property of this CloudAutomationFreezePeriod.
        :type freeze_period_end_time: str

        """
        self.swagger_types = {
            'freeze_period_start_time': 'str',
            'freeze_period_end_time': 'str'
        }

        self.attribute_map = {
            'freeze_period_start_time': 'freezePeriodStartTime',
            'freeze_period_end_time': 'freezePeriodEndTime'
        }

        self._freeze_period_start_time = None
        self._freeze_period_end_time = None

    @property
    def freeze_period_start_time(self):
        """
        Gets the freeze_period_start_time of this CloudAutomationFreezePeriod.
        Start time of the freeze period cycle.


        :return: The freeze_period_start_time of this CloudAutomationFreezePeriod.
        :rtype: str
        """
        return self._freeze_period_start_time

    @freeze_period_start_time.setter
    def freeze_period_start_time(self, freeze_period_start_time):
        """
        Sets the freeze_period_start_time of this CloudAutomationFreezePeriod.
        Start time of the freeze period cycle.


        :param freeze_period_start_time: The freeze_period_start_time of this CloudAutomationFreezePeriod.
        :type: str
        """
        self._freeze_period_start_time = freeze_period_start_time

    @property
    def freeze_period_end_time(self):
        """
        Gets the freeze_period_end_time of this CloudAutomationFreezePeriod.
        End time of the freeze period cycle.


        :return: The freeze_period_end_time of this CloudAutomationFreezePeriod.
        :rtype: str
        """
        return self._freeze_period_end_time

    @freeze_period_end_time.setter
    def freeze_period_end_time(self, freeze_period_end_time):
        """
        Sets the freeze_period_end_time of this CloudAutomationFreezePeriod.
        End time of the freeze period cycle.


        :param freeze_period_end_time: The freeze_period_end_time of this CloudAutomationFreezePeriod.
        :type: str
        """
        self._freeze_period_end_time = freeze_period_end_time

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
