# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CloudAutomationApplyUpdateTimePreference(object):
    """
    Configure the time slot for applying VM cloud automation software updates to the cluster. When nothing is selected, the default time slot is 12 AM to 2 AM UTC. Any 2-hour slot is available starting at 12 AM.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CloudAutomationApplyUpdateTimePreference object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param apply_update_preferred_start_time:
            The value to assign to the apply_update_preferred_start_time property of this CloudAutomationApplyUpdateTimePreference.
        :type apply_update_preferred_start_time: str

        :param apply_update_preferred_end_time:
            The value to assign to the apply_update_preferred_end_time property of this CloudAutomationApplyUpdateTimePreference.
        :type apply_update_preferred_end_time: str

        """
        self.swagger_types = {
            'apply_update_preferred_start_time': 'str',
            'apply_update_preferred_end_time': 'str'
        }

        self.attribute_map = {
            'apply_update_preferred_start_time': 'applyUpdatePreferredStartTime',
            'apply_update_preferred_end_time': 'applyUpdatePreferredEndTime'
        }

        self._apply_update_preferred_start_time = None
        self._apply_update_preferred_end_time = None

    @property
    def apply_update_preferred_start_time(self):
        """
        Gets the apply_update_preferred_start_time of this CloudAutomationApplyUpdateTimePreference.
        Start time for polling VM cloud automation software updates for the cluster. If the startTime is not specified, 12 AM UTC is used by default.


        :return: The apply_update_preferred_start_time of this CloudAutomationApplyUpdateTimePreference.
        :rtype: str
        """
        return self._apply_update_preferred_start_time

    @apply_update_preferred_start_time.setter
    def apply_update_preferred_start_time(self, apply_update_preferred_start_time):
        """
        Sets the apply_update_preferred_start_time of this CloudAutomationApplyUpdateTimePreference.
        Start time for polling VM cloud automation software updates for the cluster. If the startTime is not specified, 12 AM UTC is used by default.


        :param apply_update_preferred_start_time: The apply_update_preferred_start_time of this CloudAutomationApplyUpdateTimePreference.
        :type: str
        """
        self._apply_update_preferred_start_time = apply_update_preferred_start_time

    @property
    def apply_update_preferred_end_time(self):
        """
        Gets the apply_update_preferred_end_time of this CloudAutomationApplyUpdateTimePreference.
        End time for polling VM cloud automation software updates for the cluster. If the endTime is not specified, 2 AM UTC is used by default.


        :return: The apply_update_preferred_end_time of this CloudAutomationApplyUpdateTimePreference.
        :rtype: str
        """
        return self._apply_update_preferred_end_time

    @apply_update_preferred_end_time.setter
    def apply_update_preferred_end_time(self, apply_update_preferred_end_time):
        """
        Sets the apply_update_preferred_end_time of this CloudAutomationApplyUpdateTimePreference.
        End time for polling VM cloud automation software updates for the cluster. If the endTime is not specified, 2 AM UTC is used by default.


        :param apply_update_preferred_end_time: The apply_update_preferred_end_time of this CloudAutomationApplyUpdateTimePreference.
        :type: str
        """
        self._apply_update_preferred_end_time = apply_update_preferred_end_time

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
