# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918

from .autonomous_database_encryption_key_details import AutonomousDatabaseEncryptionKeyDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AwsKeyDetails(AutonomousDatabaseEncryptionKeyDetails):
    """
    Details for AWS encryption key.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AwsKeyDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.database.models.AwsKeyDetails.provider` attribute
        of this class is ``AWS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param provider:
            The value to assign to the provider property of this AwsKeyDetails.
            Allowed values for this property are: "AWS", "AZURE", "OCI", "ORACLE_MANAGED", "OKV"
        :type provider: str

        :param service_endpoint_uri:
            The value to assign to the service_endpoint_uri property of this AwsKeyDetails.
        :type service_endpoint_uri: str

        :param key_arn:
            The value to assign to the key_arn property of this AwsKeyDetails.
        :type key_arn: str

        :param arn_role:
            The value to assign to the arn_role property of this AwsKeyDetails.
        :type arn_role: str

        :param external_id:
            The value to assign to the external_id property of this AwsKeyDetails.
        :type external_id: str

        """
        self.swagger_types = {
            'provider': 'str',
            'service_endpoint_uri': 'str',
            'key_arn': 'str',
            'arn_role': 'str',
            'external_id': 'str'
        }

        self.attribute_map = {
            'provider': 'provider',
            'service_endpoint_uri': 'serviceEndpointUri',
            'key_arn': 'keyArn',
            'arn_role': 'arnRole',
            'external_id': 'externalId'
        }

        self._provider = None
        self._service_endpoint_uri = None
        self._key_arn = None
        self._arn_role = None
        self._external_id = None
        self._provider = 'AWS'

    @property
    def service_endpoint_uri(self):
        """
        **[Required]** Gets the service_endpoint_uri of this AwsKeyDetails.
        AWS key service endpoint URI


        :return: The service_endpoint_uri of this AwsKeyDetails.
        :rtype: str
        """
        return self._service_endpoint_uri

    @service_endpoint_uri.setter
    def service_endpoint_uri(self, service_endpoint_uri):
        """
        Sets the service_endpoint_uri of this AwsKeyDetails.
        AWS key service endpoint URI


        :param service_endpoint_uri: The service_endpoint_uri of this AwsKeyDetails.
        :type: str
        """
        self._service_endpoint_uri = service_endpoint_uri

    @property
    def key_arn(self):
        """
        **[Required]** Gets the key_arn of this AwsKeyDetails.
        AWS key ARN


        :return: The key_arn of this AwsKeyDetails.
        :rtype: str
        """
        return self._key_arn

    @key_arn.setter
    def key_arn(self, key_arn):
        """
        Sets the key_arn of this AwsKeyDetails.
        AWS key ARN


        :param key_arn: The key_arn of this AwsKeyDetails.
        :type: str
        """
        self._key_arn = key_arn

    @property
    def arn_role(self):
        """
        Gets the arn_role of this AwsKeyDetails.
        AWS ARN role


        :return: The arn_role of this AwsKeyDetails.
        :rtype: str
        """
        return self._arn_role

    @arn_role.setter
    def arn_role(self, arn_role):
        """
        Sets the arn_role of this AwsKeyDetails.
        AWS ARN role


        :param arn_role: The arn_role of this AwsKeyDetails.
        :type: str
        """
        self._arn_role = arn_role

    @property
    def external_id(self):
        """
        Gets the external_id of this AwsKeyDetails.
        AWS external ID


        :return: The external_id of this AwsKeyDetails.
        :rtype: str
        """
        return self._external_id

    @external_id.setter
    def external_id(self, external_id):
        """
        Sets the external_id of this AwsKeyDetails.
        AWS external ID


        :param external_id: The external_id of this AwsKeyDetails.
        :type: str
        """
        self._external_id = external_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
