# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ScalingConfiguration(object):
    """
    Scaling configuration for the metric expression rule.
    """

    #: A constant which can be used with the scaling_configuration_type property of a ScalingConfiguration.
    #: This constant has a value of "THRESHOLD"
    SCALING_CONFIGURATION_TYPE_THRESHOLD = "THRESHOLD"

    #: A constant which can be used with the scaling_configuration_type property of a ScalingConfiguration.
    #: This constant has a value of "QUERY"
    SCALING_CONFIGURATION_TYPE_QUERY = "QUERY"

    def __init__(self, **kwargs):
        """
        Initializes a new ScalingConfiguration object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.data_science.models.CustomExpressionQueryScalingConfiguration`
        * :class:`~oci.data_science.models.PredefinedExpressionThresholdScalingConfiguration`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param scaling_configuration_type:
            The value to assign to the scaling_configuration_type property of this ScalingConfiguration.
            Allowed values for this property are: "THRESHOLD", "QUERY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type scaling_configuration_type: str

        :param pending_duration:
            The value to assign to the pending_duration property of this ScalingConfiguration.
        :type pending_duration: str

        :param instance_count_adjustment:
            The value to assign to the instance_count_adjustment property of this ScalingConfiguration.
        :type instance_count_adjustment: int

        """
        self.swagger_types = {
            'scaling_configuration_type': 'str',
            'pending_duration': 'str',
            'instance_count_adjustment': 'int'
        }

        self.attribute_map = {
            'scaling_configuration_type': 'scalingConfigurationType',
            'pending_duration': 'pendingDuration',
            'instance_count_adjustment': 'instanceCountAdjustment'
        }

        self._scaling_configuration_type = None
        self._pending_duration = None
        self._instance_count_adjustment = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['scalingConfigurationType']

        if type == 'QUERY':
            return 'CustomExpressionQueryScalingConfiguration'

        if type == 'THRESHOLD':
            return 'PredefinedExpressionThresholdScalingConfiguration'
        else:
            return 'ScalingConfiguration'

    @property
    def scaling_configuration_type(self):
        """
        **[Required]** Gets the scaling_configuration_type of this ScalingConfiguration.
        The type of scaling configuration.

        Allowed values for this property are: "THRESHOLD", "QUERY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The scaling_configuration_type of this ScalingConfiguration.
        :rtype: str
        """
        return self._scaling_configuration_type

    @scaling_configuration_type.setter
    def scaling_configuration_type(self, scaling_configuration_type):
        """
        Sets the scaling_configuration_type of this ScalingConfiguration.
        The type of scaling configuration.


        :param scaling_configuration_type: The scaling_configuration_type of this ScalingConfiguration.
        :type: str
        """
        allowed_values = ["THRESHOLD", "QUERY"]
        if not value_allowed_none_or_none_sentinel(scaling_configuration_type, allowed_values):
            scaling_configuration_type = 'UNKNOWN_ENUM_VALUE'
        self._scaling_configuration_type = scaling_configuration_type

    @property
    def pending_duration(self):
        """
        Gets the pending_duration of this ScalingConfiguration.
        The period of time that the condition defined in the alarm must persist before the alarm state
        changes from \"OK\" to \"FIRING\" or vice versa. For example, a value of 5 minutes means that the
        alarm must persist in breaching the condition for five minutes before the alarm updates its
        state to \"FIRING\"; likewise, the alarm must persist in not breaching the condition for five
        minutes before the alarm updates its state to \"OK.\"

        The duration is specified as a string in ISO 8601 format (`PT10M` for ten minutes or `PT1H`
        for one hour). Minimum: PT3M. Maximum: PT1H. Default: PT3M.


        :return: The pending_duration of this ScalingConfiguration.
        :rtype: str
        """
        return self._pending_duration

    @pending_duration.setter
    def pending_duration(self, pending_duration):
        """
        Sets the pending_duration of this ScalingConfiguration.
        The period of time that the condition defined in the alarm must persist before the alarm state
        changes from \"OK\" to \"FIRING\" or vice versa. For example, a value of 5 minutes means that the
        alarm must persist in breaching the condition for five minutes before the alarm updates its
        state to \"FIRING\"; likewise, the alarm must persist in not breaching the condition for five
        minutes before the alarm updates its state to \"OK.\"

        The duration is specified as a string in ISO 8601 format (`PT10M` for ten minutes or `PT1H`
        for one hour). Minimum: PT3M. Maximum: PT1H. Default: PT3M.


        :param pending_duration: The pending_duration of this ScalingConfiguration.
        :type: str
        """
        self._pending_duration = pending_duration

    @property
    def instance_count_adjustment(self):
        """
        Gets the instance_count_adjustment of this ScalingConfiguration.
        The value is used for adjusting the count of instances by.


        :return: The instance_count_adjustment of this ScalingConfiguration.
        :rtype: int
        """
        return self._instance_count_adjustment

    @instance_count_adjustment.setter
    def instance_count_adjustment(self, instance_count_adjustment):
        """
        Sets the instance_count_adjustment of this ScalingConfiguration.
        The value is used for adjusting the count of instances by.


        :param instance_count_adjustment: The instance_count_adjustment of this ScalingConfiguration.
        :type: int
        """
        self._instance_count_adjustment = instance_count_adjustment

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
