# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BackupSetting(object):
    """
    Back up setting details of the model.
    """

    #: A constant which can be used with the customer_notification_type property of a BackupSetting.
    #: This constant has a value of "NONE"
    CUSTOMER_NOTIFICATION_TYPE_NONE = "NONE"

    #: A constant which can be used with the customer_notification_type property of a BackupSetting.
    #: This constant has a value of "ALL"
    CUSTOMER_NOTIFICATION_TYPE_ALL = "ALL"

    #: A constant which can be used with the customer_notification_type property of a BackupSetting.
    #: This constant has a value of "ON_FAILURE"
    CUSTOMER_NOTIFICATION_TYPE_ON_FAILURE = "ON_FAILURE"

    #: A constant which can be used with the customer_notification_type property of a BackupSetting.
    #: This constant has a value of "ON_SUCCESS"
    CUSTOMER_NOTIFICATION_TYPE_ON_SUCCESS = "ON_SUCCESS"

    def __init__(self, **kwargs):
        """
        Initializes a new BackupSetting object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_backup_enabled:
            The value to assign to the is_backup_enabled property of this BackupSetting.
        :type is_backup_enabled: bool

        :param backup_region:
            The value to assign to the backup_region property of this BackupSetting.
        :type backup_region: str

        :param customer_notification_type:
            The value to assign to the customer_notification_type property of this BackupSetting.
            Allowed values for this property are: "NONE", "ALL", "ON_FAILURE", "ON_SUCCESS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type customer_notification_type: str

        """
        self.swagger_types = {
            'is_backup_enabled': 'bool',
            'backup_region': 'str',
            'customer_notification_type': 'str'
        }

        self.attribute_map = {
            'is_backup_enabled': 'isBackupEnabled',
            'backup_region': 'backupRegion',
            'customer_notification_type': 'customerNotificationType'
        }

        self._is_backup_enabled = None
        self._backup_region = None
        self._customer_notification_type = None

    @property
    def is_backup_enabled(self):
        """
        **[Required]** Gets the is_backup_enabled of this BackupSetting.
        Boolean flag representing whether backup needs to be enabled/disabled for the model.


        :return: The is_backup_enabled of this BackupSetting.
        :rtype: bool
        """
        return self._is_backup_enabled

    @is_backup_enabled.setter
    def is_backup_enabled(self, is_backup_enabled):
        """
        Sets the is_backup_enabled of this BackupSetting.
        Boolean flag representing whether backup needs to be enabled/disabled for the model.


        :param is_backup_enabled: The is_backup_enabled of this BackupSetting.
        :type: bool
        """
        self._is_backup_enabled = is_backup_enabled

    @property
    def backup_region(self):
        """
        **[Required]** Gets the backup_region of this BackupSetting.
        OCI backup region for the model.


        :return: The backup_region of this BackupSetting.
        :rtype: str
        """
        return self._backup_region

    @backup_region.setter
    def backup_region(self, backup_region):
        """
        Sets the backup_region of this BackupSetting.
        OCI backup region for the model.


        :param backup_region: The backup_region of this BackupSetting.
        :type: str
        """
        self._backup_region = backup_region

    @property
    def customer_notification_type(self):
        """
        Gets the customer_notification_type of this BackupSetting.
        Customer notification on backup success/failure events.

        Allowed values for this property are: "NONE", "ALL", "ON_FAILURE", "ON_SUCCESS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The customer_notification_type of this BackupSetting.
        :rtype: str
        """
        return self._customer_notification_type

    @customer_notification_type.setter
    def customer_notification_type(self, customer_notification_type):
        """
        Sets the customer_notification_type of this BackupSetting.
        Customer notification on backup success/failure events.


        :param customer_notification_type: The customer_notification_type of this BackupSetting.
        :type: str
        """
        allowed_values = ["NONE", "ALL", "ON_FAILURE", "ON_SUCCESS"]
        if not value_allowed_none_or_none_sentinel(customer_notification_type, allowed_values):
            customer_notification_type = 'UNKNOWN_ENUM_VALUE'
        self._customer_notification_type = customer_notification_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
