# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UnsetUserAssessmentBaselineDetails(object):
    """
    The details required to unset the baseline of the assessment.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UnsetUserAssessmentBaselineDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param target_ids:
            The value to assign to the target_ids property of this UnsetUserAssessmentBaselineDetails.
        :type target_ids: list[str]

        """
        self.swagger_types = {
            'target_ids': 'list[str]'
        }

        self.attribute_map = {
            'target_ids': 'targetIds'
        }

        self._target_ids = None

    @property
    def target_ids(self):
        """
        Gets the target_ids of this UnsetUserAssessmentBaselineDetails.
        The list of database target OCIDs for which the user intends to unset the baseline.


        :return: The target_ids of this UnsetUserAssessmentBaselineDetails.
        :rtype: list[str]
        """
        return self._target_ids

    @target_ids.setter
    def target_ids(self, target_ids):
        """
        Sets the target_ids of this UnsetUserAssessmentBaselineDetails.
        The list of database target OCIDs for which the user intends to unset the baseline.


        :param target_ids: The target_ids of this UnsetUserAssessmentBaselineDetails.
        :type: list[str]
        """
        self._target_ids = target_ids

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
