# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200430


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class IncrementalDataEntityClause(object):
    """
    Data Entity clause for Incremental Read operation.
    """

    #: A constant which can be used with the incremental_comparator property of a IncrementalDataEntityClause.
    #: This constant has a value of "LESSTHAN"
    INCREMENTAL_COMPARATOR_LESSTHAN = "LESSTHAN"

    #: A constant which can be used with the incremental_comparator property of a IncrementalDataEntityClause.
    #: This constant has a value of "GREATERTHAN"
    INCREMENTAL_COMPARATOR_GREATERTHAN = "GREATERTHAN"

    #: A constant which can be used with the incremental_comparator property of a IncrementalDataEntityClause.
    #: This constant has a value of "EQUALS"
    INCREMENTAL_COMPARATOR_EQUALS = "EQUALS"

    #: A constant which can be used with the incremental_comparator property of a IncrementalDataEntityClause.
    #: This constant has a value of "LESSTHANEQUALS"
    INCREMENTAL_COMPARATOR_LESSTHANEQUALS = "LESSTHANEQUALS"

    #: A constant which can be used with the incremental_comparator property of a IncrementalDataEntityClause.
    #: This constant has a value of "GREATERTHANEQUALS"
    INCREMENTAL_COMPARATOR_GREATERTHANEQUALS = "GREATERTHANEQUALS"

    #: A constant which can be used with the incremental_comparator property of a IncrementalDataEntityClause.
    #: This constant has a value of "STARTSWITH"
    INCREMENTAL_COMPARATOR_STARTSWITH = "STARTSWITH"

    #: A constant which can be used with the incremental_comparator property of a IncrementalDataEntityClause.
    #: This constant has a value of "CONTAINS"
    INCREMENTAL_COMPARATOR_CONTAINS = "CONTAINS"

    def __init__(self, **kwargs):
        """
        Initializes a new IncrementalDataEntityClause object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param incremental_data_entity_name:
            The value to assign to the incremental_data_entity_name property of this IncrementalDataEntityClause.
        :type incremental_data_entity_name: str

        :param incremental_data_entity_value:
            The value to assign to the incremental_data_entity_value property of this IncrementalDataEntityClause.
        :type incremental_data_entity_value: dict(str, str)

        :param incremental_comparator:
            The value to assign to the incremental_comparator property of this IncrementalDataEntityClause.
            Allowed values for this property are: "LESSTHAN", "GREATERTHAN", "EQUALS", "LESSTHANEQUALS", "GREATERTHANEQUALS", "STARTSWITH", "CONTAINS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type incremental_comparator: str

        """
        self.swagger_types = {
            'incremental_data_entity_name': 'str',
            'incremental_data_entity_value': 'dict(str, str)',
            'incremental_comparator': 'str'
        }

        self.attribute_map = {
            'incremental_data_entity_name': 'incrementalDataEntityName',
            'incremental_data_entity_value': 'incrementalDataEntityValue',
            'incremental_comparator': 'incrementalComparator'
        }

        self._incremental_data_entity_name = None
        self._incremental_data_entity_value = None
        self._incremental_comparator = None

    @property
    def incremental_data_entity_name(self):
        """
        **[Required]** Gets the incremental_data_entity_name of this IncrementalDataEntityClause.
        Name of incremental data entity filter.


        :return: The incremental_data_entity_name of this IncrementalDataEntityClause.
        :rtype: str
        """
        return self._incremental_data_entity_name

    @incremental_data_entity_name.setter
    def incremental_data_entity_name(self, incremental_data_entity_name):
        """
        Sets the incremental_data_entity_name of this IncrementalDataEntityClause.
        Name of incremental data entity filter.


        :param incremental_data_entity_name: The incremental_data_entity_name of this IncrementalDataEntityClause.
        :type: str
        """
        self._incremental_data_entity_name = incremental_data_entity_name

    @property
    def incremental_data_entity_value(self):
        """
        **[Required]** Gets the incremental_data_entity_value of this IncrementalDataEntityClause.
        Value of incremental data entity filter.


        :return: The incremental_data_entity_value of this IncrementalDataEntityClause.
        :rtype: dict(str, str)
        """
        return self._incremental_data_entity_value

    @incremental_data_entity_value.setter
    def incremental_data_entity_value(self, incremental_data_entity_value):
        """
        Sets the incremental_data_entity_value of this IncrementalDataEntityClause.
        Value of incremental data entity filter.


        :param incremental_data_entity_value: The incremental_data_entity_value of this IncrementalDataEntityClause.
        :type: dict(str, str)
        """
        self._incremental_data_entity_value = incremental_data_entity_value

    @property
    def incremental_comparator(self):
        """
        **[Required]** Gets the incremental_comparator of this IncrementalDataEntityClause.
        Incremental comparator symbol.

        Allowed values for this property are: "LESSTHAN", "GREATERTHAN", "EQUALS", "LESSTHANEQUALS", "GREATERTHANEQUALS", "STARTSWITH", "CONTAINS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The incremental_comparator of this IncrementalDataEntityClause.
        :rtype: str
        """
        return self._incremental_comparator

    @incremental_comparator.setter
    def incremental_comparator(self, incremental_comparator):
        """
        Sets the incremental_comparator of this IncrementalDataEntityClause.
        Incremental comparator symbol.


        :param incremental_comparator: The incremental_comparator of this IncrementalDataEntityClause.
        :type: str
        """
        allowed_values = ["LESSTHAN", "GREATERTHAN", "EQUALS", "LESSTHANEQUALS", "GREATERTHANEQUALS", "STARTSWITH", "CONTAINS"]
        if not value_allowed_none_or_none_sentinel(incremental_comparator, allowed_values):
            incremental_comparator = 'UNKNOWN_ENUM_VALUE'
        self._incremental_comparator = incremental_comparator

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
