# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200430


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ImportConflictResolution(object):
    """
    Import Objects Conflict resolution.
    """

    #: A constant which can be used with the import_conflict_resolution_type property of a ImportConflictResolution.
    #: This constant has a value of "DUPLICATE"
    IMPORT_CONFLICT_RESOLUTION_TYPE_DUPLICATE = "DUPLICATE"

    #: A constant which can be used with the import_conflict_resolution_type property of a ImportConflictResolution.
    #: This constant has a value of "REPLACE"
    IMPORT_CONFLICT_RESOLUTION_TYPE_REPLACE = "REPLACE"

    #: A constant which can be used with the import_conflict_resolution_type property of a ImportConflictResolution.
    #: This constant has a value of "RETAIN"
    IMPORT_CONFLICT_RESOLUTION_TYPE_RETAIN = "RETAIN"

    def __init__(self, **kwargs):
        """
        Initializes a new ImportConflictResolution object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param duplicate_prefix:
            The value to assign to the duplicate_prefix property of this ImportConflictResolution.
        :type duplicate_prefix: str

        :param duplicate_suffix:
            The value to assign to the duplicate_suffix property of this ImportConflictResolution.
        :type duplicate_suffix: str

        :param import_conflict_resolution_type:
            The value to assign to the import_conflict_resolution_type property of this ImportConflictResolution.
            Allowed values for this property are: "DUPLICATE", "REPLACE", "RETAIN", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type import_conflict_resolution_type: str

        """
        self.swagger_types = {
            'duplicate_prefix': 'str',
            'duplicate_suffix': 'str',
            'import_conflict_resolution_type': 'str'
        }

        self.attribute_map = {
            'duplicate_prefix': 'duplicatePrefix',
            'duplicate_suffix': 'duplicateSuffix',
            'import_conflict_resolution_type': 'importConflictResolutionType'
        }

        self._duplicate_prefix = None
        self._duplicate_suffix = None
        self._import_conflict_resolution_type = None

    @property
    def duplicate_prefix(self):
        """
        Gets the duplicate_prefix of this ImportConflictResolution.
        In case of DUPLICATE mode, prefix will be used to disambiguate the object.


        :return: The duplicate_prefix of this ImportConflictResolution.
        :rtype: str
        """
        return self._duplicate_prefix

    @duplicate_prefix.setter
    def duplicate_prefix(self, duplicate_prefix):
        """
        Sets the duplicate_prefix of this ImportConflictResolution.
        In case of DUPLICATE mode, prefix will be used to disambiguate the object.


        :param duplicate_prefix: The duplicate_prefix of this ImportConflictResolution.
        :type: str
        """
        self._duplicate_prefix = duplicate_prefix

    @property
    def duplicate_suffix(self):
        """
        Gets the duplicate_suffix of this ImportConflictResolution.
        In case of DUPLICATE mode, suffix will be used to disambiguate the object.


        :return: The duplicate_suffix of this ImportConflictResolution.
        :rtype: str
        """
        return self._duplicate_suffix

    @duplicate_suffix.setter
    def duplicate_suffix(self, duplicate_suffix):
        """
        Sets the duplicate_suffix of this ImportConflictResolution.
        In case of DUPLICATE mode, suffix will be used to disambiguate the object.


        :param duplicate_suffix: The duplicate_suffix of this ImportConflictResolution.
        :type: str
        """
        self._duplicate_suffix = duplicate_suffix

    @property
    def import_conflict_resolution_type(self):
        """
        **[Required]** Gets the import_conflict_resolution_type of this ImportConflictResolution.
        Import Objects Conflict resolution Type (RETAIN/DUPLICATE/REPLACE).

        Allowed values for this property are: "DUPLICATE", "REPLACE", "RETAIN", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The import_conflict_resolution_type of this ImportConflictResolution.
        :rtype: str
        """
        return self._import_conflict_resolution_type

    @import_conflict_resolution_type.setter
    def import_conflict_resolution_type(self, import_conflict_resolution_type):
        """
        Sets the import_conflict_resolution_type of this ImportConflictResolution.
        Import Objects Conflict resolution Type (RETAIN/DUPLICATE/REPLACE).


        :param import_conflict_resolution_type: The import_conflict_resolution_type of this ImportConflictResolution.
        :type: str
        """
        allowed_values = ["DUPLICATE", "REPLACE", "RETAIN"]
        if not value_allowed_none_or_none_sentinel(import_conflict_resolution_type, allowed_values):
            import_conflict_resolution_type = 'UNKNOWN_ENUM_VALUE'
        self._import_conflict_resolution_type = import_conflict_resolution_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
