# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateInstanceMaintenanceEventDetails(object):
    """
    Specifies the properties for updating maintenance due date.
    """

    #: A constant which can be used with the alternative_resolution_action property of a UpdateInstanceMaintenanceEventDetails.
    #: This constant has a value of "REBOOT_MIGRATION"
    ALTERNATIVE_RESOLUTION_ACTION_REBOOT_MIGRATION = "REBOOT_MIGRATION"

    #: A constant which can be used with the alternative_resolution_action property of a UpdateInstanceMaintenanceEventDetails.
    #: This constant has a value of "TERMINATE"
    ALTERNATIVE_RESOLUTION_ACTION_TERMINATE = "TERMINATE"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateInstanceMaintenanceEventDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param time_window_start:
            The value to assign to the time_window_start property of this UpdateInstanceMaintenanceEventDetails.
        :type time_window_start: datetime

        :param alternative_resolution_action:
            The value to assign to the alternative_resolution_action property of this UpdateInstanceMaintenanceEventDetails.
            Allowed values for this property are: "REBOOT_MIGRATION", "TERMINATE"
        :type alternative_resolution_action: str

        :param can_delete_local_storage:
            The value to assign to the can_delete_local_storage property of this UpdateInstanceMaintenanceEventDetails.
        :type can_delete_local_storage: bool

        :param display_name:
            The value to assign to the display_name property of this UpdateInstanceMaintenanceEventDetails.
        :type display_name: str

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateInstanceMaintenanceEventDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateInstanceMaintenanceEventDetails.
        :type freeform_tags: dict(str, str)

        """
        self.swagger_types = {
            'time_window_start': 'datetime',
            'alternative_resolution_action': 'str',
            'can_delete_local_storage': 'bool',
            'display_name': 'str',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)'
        }

        self.attribute_map = {
            'time_window_start': 'timeWindowStart',
            'alternative_resolution_action': 'alternativeResolutionAction',
            'can_delete_local_storage': 'canDeleteLocalStorage',
            'display_name': 'displayName',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags'
        }

        self._time_window_start = None
        self._alternative_resolution_action = None
        self._can_delete_local_storage = None
        self._display_name = None
        self._defined_tags = None
        self._freeform_tags = None

    @property
    def time_window_start(self):
        """
        Gets the time_window_start of this UpdateInstanceMaintenanceEventDetails.
        The beginning of the time window when Maintenance is scheduled to begin. The Maintenance will not begin before
        this time.

        The timeWindowEnd is automatically calculated based on the maintenanceReason and the instanceAction.


        :return: The time_window_start of this UpdateInstanceMaintenanceEventDetails.
        :rtype: datetime
        """
        return self._time_window_start

    @time_window_start.setter
    def time_window_start(self, time_window_start):
        """
        Sets the time_window_start of this UpdateInstanceMaintenanceEventDetails.
        The beginning of the time window when Maintenance is scheduled to begin. The Maintenance will not begin before
        this time.

        The timeWindowEnd is automatically calculated based on the maintenanceReason and the instanceAction.


        :param time_window_start: The time_window_start of this UpdateInstanceMaintenanceEventDetails.
        :type: datetime
        """
        self._time_window_start = time_window_start

    @property
    def alternative_resolution_action(self):
        """
        Gets the alternative_resolution_action of this UpdateInstanceMaintenanceEventDetails.
        One of the alternativeResolutionActions that was provided in the InstanceMaintenanceEvent.

        Allowed values for this property are: "REBOOT_MIGRATION", "TERMINATE"


        :return: The alternative_resolution_action of this UpdateInstanceMaintenanceEventDetails.
        :rtype: str
        """
        return self._alternative_resolution_action

    @alternative_resolution_action.setter
    def alternative_resolution_action(self, alternative_resolution_action):
        """
        Sets the alternative_resolution_action of this UpdateInstanceMaintenanceEventDetails.
        One of the alternativeResolutionActions that was provided in the InstanceMaintenanceEvent.


        :param alternative_resolution_action: The alternative_resolution_action of this UpdateInstanceMaintenanceEventDetails.
        :type: str
        """
        allowed_values = ["REBOOT_MIGRATION", "TERMINATE"]
        if not value_allowed_none_or_none_sentinel(alternative_resolution_action, allowed_values):
            raise ValueError(
                f"Invalid value for `alternative_resolution_action`, must be None or one of {allowed_values}"
            )
        self._alternative_resolution_action = alternative_resolution_action

    @property
    def can_delete_local_storage(self):
        """
        Gets the can_delete_local_storage of this UpdateInstanceMaintenanceEventDetails.
        This field is only applicable when setting the alternativeResolutionAction.

        For Instances that have local storage, this must be set to true to verify that the local storage
        will be deleted during the migration. For instances without, this parameter has no effect.

        In cases where the local storage will be lost, this parameter must be set or the request will fail.


        :return: The can_delete_local_storage of this UpdateInstanceMaintenanceEventDetails.
        :rtype: bool
        """
        return self._can_delete_local_storage

    @can_delete_local_storage.setter
    def can_delete_local_storage(self, can_delete_local_storage):
        """
        Sets the can_delete_local_storage of this UpdateInstanceMaintenanceEventDetails.
        This field is only applicable when setting the alternativeResolutionAction.

        For Instances that have local storage, this must be set to true to verify that the local storage
        will be deleted during the migration. For instances without, this parameter has no effect.

        In cases where the local storage will be lost, this parameter must be set or the request will fail.


        :param can_delete_local_storage: The can_delete_local_storage of this UpdateInstanceMaintenanceEventDetails.
        :type: bool
        """
        self._can_delete_local_storage = can_delete_local_storage

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateInstanceMaintenanceEventDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this UpdateInstanceMaintenanceEventDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateInstanceMaintenanceEventDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this UpdateInstanceMaintenanceEventDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateInstanceMaintenanceEventDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateInstanceMaintenanceEventDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateInstanceMaintenanceEventDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateInstanceMaintenanceEventDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateInstanceMaintenanceEventDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateInstanceMaintenanceEventDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateInstanceMaintenanceEventDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateInstanceMaintenanceEventDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
