# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Ipam(object):
    """
    An IPAM refers to a group of VCNs, subnets, IP resources
    and its related properties.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Ipam object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param placeholder:
            The value to assign to the placeholder property of this Ipam.
        :type placeholder: str

        """
        self.swagger_types = {
            'placeholder': 'str'
        }

        self.attribute_map = {
            'placeholder': 'placeholder'
        }

        self._placeholder = None

    @property
    def placeholder(self):
        """
        Gets the placeholder of this Ipam.
        Placeholder for description


        :return: The placeholder of this Ipam.
        :rtype: str
        """
        return self._placeholder

    @placeholder.setter
    def placeholder(self, placeholder):
        """
        Sets the placeholder of this Ipam.
        Placeholder for description


        :param placeholder: The placeholder of this Ipam.
        :type: str
        """
        self._placeholder = placeholder

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
