# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InventorySubnetSummary(object):
    """
    Lists subnet and its associated resources.
    """

    #: A constant which can be used with the resource_type property of a InventorySubnetSummary.
    #: This constant has a value of "Subnet"
    RESOURCE_TYPE_SUBNET = "Subnet"

    def __init__(self, **kwargs):
        """
        Initializes a new InventorySubnetSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param subnet_id:
            The value to assign to the subnet_id property of this InventorySubnetSummary.
        :type subnet_id: str

        :param subnet_name:
            The value to assign to the subnet_name property of this InventorySubnetSummary.
        :type subnet_name: str

        :param resource_type:
            The value to assign to the resource_type property of this InventorySubnetSummary.
            Allowed values for this property are: "Subnet", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type resource_type: str

        :param inventory_subnet_cidr_collection:
            The value to assign to the inventory_subnet_cidr_collection property of this InventorySubnetSummary.
        :type inventory_subnet_cidr_collection: list[oci.core.models.InventorySubnetCidrBlockSummary]

        :param dns_domain_name:
            The value to assign to the dns_domain_name property of this InventorySubnetSummary.
        :type dns_domain_name: str

        :param region:
            The value to assign to the region property of this InventorySubnetSummary.
        :type region: str

        :param compartment_id:
            The value to assign to the compartment_id property of this InventorySubnetSummary.
        :type compartment_id: str

        :param inventory_resource_summary:
            The value to assign to the inventory_resource_summary property of this InventorySubnetSummary.
        :type inventory_resource_summary: list[oci.core.models.InventoryResourceSummary]

        """
        self.swagger_types = {
            'subnet_id': 'str',
            'subnet_name': 'str',
            'resource_type': 'str',
            'inventory_subnet_cidr_collection': 'list[InventorySubnetCidrBlockSummary]',
            'dns_domain_name': 'str',
            'region': 'str',
            'compartment_id': 'str',
            'inventory_resource_summary': 'list[InventoryResourceSummary]'
        }

        self.attribute_map = {
            'subnet_id': 'subnetId',
            'subnet_name': 'subnetName',
            'resource_type': 'resourceType',
            'inventory_subnet_cidr_collection': 'inventorySubnetCidrCollection',
            'dns_domain_name': 'dnsDomainName',
            'region': 'region',
            'compartment_id': 'compartmentId',
            'inventory_resource_summary': 'inventoryResourceSummary'
        }

        self._subnet_id = None
        self._subnet_name = None
        self._resource_type = None
        self._inventory_subnet_cidr_collection = None
        self._dns_domain_name = None
        self._region = None
        self._compartment_id = None
        self._inventory_resource_summary = None

    @property
    def subnet_id(self):
        """
        Gets the subnet_id of this InventorySubnetSummary.
        The `OCID`__ of the subnet.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The subnet_id of this InventorySubnetSummary.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this InventorySubnetSummary.
        The `OCID`__ of the subnet.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param subnet_id: The subnet_id of this InventorySubnetSummary.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def subnet_name(self):
        """
        Gets the subnet_name of this InventorySubnetSummary.
        Name of the subnet within a VCN.


        :return: The subnet_name of this InventorySubnetSummary.
        :rtype: str
        """
        return self._subnet_name

    @subnet_name.setter
    def subnet_name(self, subnet_name):
        """
        Sets the subnet_name of this InventorySubnetSummary.
        Name of the subnet within a VCN.


        :param subnet_name: The subnet_name of this InventorySubnetSummary.
        :type: str
        """
        self._subnet_name = subnet_name

    @property
    def resource_type(self):
        """
        Gets the resource_type of this InventorySubnetSummary.
        Resource types of the subnet.

        Allowed values for this property are: "Subnet", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The resource_type of this InventorySubnetSummary.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this InventorySubnetSummary.
        Resource types of the subnet.


        :param resource_type: The resource_type of this InventorySubnetSummary.
        :type: str
        """
        allowed_values = ["Subnet"]
        if not value_allowed_none_or_none_sentinel(resource_type, allowed_values):
            resource_type = 'UNKNOWN_ENUM_VALUE'
        self._resource_type = resource_type

    @property
    def inventory_subnet_cidr_collection(self):
        """
        Gets the inventory_subnet_cidr_collection of this InventorySubnetSummary.
        Lists CIDRs and utilization within the subnet.


        :return: The inventory_subnet_cidr_collection of this InventorySubnetSummary.
        :rtype: list[oci.core.models.InventorySubnetCidrBlockSummary]
        """
        return self._inventory_subnet_cidr_collection

    @inventory_subnet_cidr_collection.setter
    def inventory_subnet_cidr_collection(self, inventory_subnet_cidr_collection):
        """
        Sets the inventory_subnet_cidr_collection of this InventorySubnetSummary.
        Lists CIDRs and utilization within the subnet.


        :param inventory_subnet_cidr_collection: The inventory_subnet_cidr_collection of this InventorySubnetSummary.
        :type: list[oci.core.models.InventorySubnetCidrBlockSummary]
        """
        self._inventory_subnet_cidr_collection = inventory_subnet_cidr_collection

    @property
    def dns_domain_name(self):
        """
        Gets the dns_domain_name of this InventorySubnetSummary.
        DNS domain name of the subnet.


        :return: The dns_domain_name of this InventorySubnetSummary.
        :rtype: str
        """
        return self._dns_domain_name

    @dns_domain_name.setter
    def dns_domain_name(self, dns_domain_name):
        """
        Sets the dns_domain_name of this InventorySubnetSummary.
        DNS domain name of the subnet.


        :param dns_domain_name: The dns_domain_name of this InventorySubnetSummary.
        :type: str
        """
        self._dns_domain_name = dns_domain_name

    @property
    def region(self):
        """
        Gets the region of this InventorySubnetSummary.
        Region name of the subnet.


        :return: The region of this InventorySubnetSummary.
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """
        Sets the region of this InventorySubnetSummary.
        Region name of the subnet.


        :param region: The region of this InventorySubnetSummary.
        :type: str
        """
        self._region = region

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this InventorySubnetSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this InventorySubnetSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this InventorySubnetSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this InventorySubnetSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def inventory_resource_summary(self):
        """
        Gets the inventory_resource_summary of this InventorySubnetSummary.
        Lists the `ResourceCollection` object.


        :return: The inventory_resource_summary of this InventorySubnetSummary.
        :rtype: list[oci.core.models.InventoryResourceSummary]
        """
        return self._inventory_resource_summary

    @inventory_resource_summary.setter
    def inventory_resource_summary(self, inventory_resource_summary):
        """
        Sets the inventory_resource_summary of this InventorySubnetSummary.
        Lists the `ResourceCollection` object.


        :param inventory_resource_summary: The inventory_resource_summary of this InventorySubnetSummary.
        :type: list[oci.core.models.InventoryResourceSummary]
        """
        self._inventory_resource_summary = inventory_resource_summary

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
