# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180222


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class StartCredentialRotationDetails(object):
    """
    Properties that define a request to start credential rotation on a kubernetes cluster.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new StartCredentialRotationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param auto_completion_delay_duration:
            The value to assign to the auto_completion_delay_duration property of this StartCredentialRotationDetails.
        :type auto_completion_delay_duration: str

        """
        self.swagger_types = {
            'auto_completion_delay_duration': 'str'
        }

        self.attribute_map = {
            'auto_completion_delay_duration': 'autoCompletionDelayDuration'
        }

        self._auto_completion_delay_duration = None

    @property
    def auto_completion_delay_duration(self):
        """
        **[Required]** Gets the auto_completion_delay_duration of this StartCredentialRotationDetails.
        The duration in days(in ISO 8601 notation eg. P5D) after which the old credentials should be retired. Maximum delay duration is 90 days.


        :return: The auto_completion_delay_duration of this StartCredentialRotationDetails.
        :rtype: str
        """
        return self._auto_completion_delay_duration

    @auto_completion_delay_duration.setter
    def auto_completion_delay_duration(self, auto_completion_delay_duration):
        """
        Sets the auto_completion_delay_duration of this StartCredentialRotationDetails.
        The duration in days(in ISO 8601 notation eg. P5D) after which the old credentials should be retired. Maximum delay duration is 90 days.


        :param auto_completion_delay_duration: The auto_completion_delay_duration of this StartCredentialRotationDetails.
        :type: str
        """
        self._auto_completion_delay_duration = auto_completion_delay_duration

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
