# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231107


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PlacementDetails(object):
    """
    Details like building, room and block where the resource was placed after provisioning in the datacenter.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PlacementDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param region:
            The value to assign to the region property of this PlacementDetails.
        :type region: str

        :param availability_domain:
            The value to assign to the availability_domain property of this PlacementDetails.
        :type availability_domain: str

        :param workload_type:
            The value to assign to the workload_type property of this PlacementDetails.
        :type workload_type: str

        :param building:
            The value to assign to the building property of this PlacementDetails.
        :type building: str

        :param room:
            The value to assign to the room property of this PlacementDetails.
        :type room: str

        :param block:
            The value to assign to the block property of this PlacementDetails.
        :type block: str

        """
        self.swagger_types = {
            'region': 'str',
            'availability_domain': 'str',
            'workload_type': 'str',
            'building': 'str',
            'room': 'str',
            'block': 'str'
        }

        self.attribute_map = {
            'region': 'region',
            'availability_domain': 'availabilityDomain',
            'workload_type': 'workloadType',
            'building': 'building',
            'room': 'room',
            'block': 'block'
        }

        self._region = None
        self._availability_domain = None
        self._workload_type = None
        self._building = None
        self._room = None
        self._block = None

    @property
    def region(self):
        """
        **[Required]** Gets the region of this PlacementDetails.
        The name of the region for which the resources were provisioned.


        :return: The region of this PlacementDetails.
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """
        Sets the region of this PlacementDetails.
        The name of the region for which the resources were provisioned.


        :param region: The region of this PlacementDetails.
        :type: str
        """
        self._region = region

    @property
    def availability_domain(self):
        """
        **[Required]** Gets the availability_domain of this PlacementDetails.
        The availability domain (AD) for which the resources were provisioned.


        :return: The availability_domain of this PlacementDetails.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this PlacementDetails.
        The availability domain (AD) for which the resources were provisioned.


        :param availability_domain: The availability_domain of this PlacementDetails.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def workload_type(self):
        """
        **[Required]** Gets the workload_type of this PlacementDetails.
        The type of workload to which these resources were provisioned.


        :return: The workload_type of this PlacementDetails.
        :rtype: str
        """
        return self._workload_type

    @workload_type.setter
    def workload_type(self, workload_type):
        """
        Sets the workload_type of this PlacementDetails.
        The type of workload to which these resources were provisioned.


        :param workload_type: The workload_type of this PlacementDetails.
        :type: str
        """
        self._workload_type = workload_type

    @property
    def building(self):
        """
        **[Required]** Gets the building of this PlacementDetails.
        The datacenter building where the resource was placed.


        :return: The building of this PlacementDetails.
        :rtype: str
        """
        return self._building

    @building.setter
    def building(self, building):
        """
        Sets the building of this PlacementDetails.
        The datacenter building where the resource was placed.


        :param building: The building of this PlacementDetails.
        :type: str
        """
        self._building = building

    @property
    def room(self):
        """
        **[Required]** Gets the room of this PlacementDetails.
        The name of the room in the dataacenter building where the resource was placed.


        :return: The room of this PlacementDetails.
        :rtype: str
        """
        return self._room

    @room.setter
    def room(self, room):
        """
        Sets the room of this PlacementDetails.
        The name of the room in the dataacenter building where the resource was placed.


        :param room: The room of this PlacementDetails.
        :type: str
        """
        self._room = room

    @property
    def block(self):
        """
        **[Required]** Gets the block of this PlacementDetails.
        The block in the datacenter room where the resource was placed.


        :return: The block of this PlacementDetails.
        :rtype: str
        """
        return self._block

    @block.setter
    def block(self, block):
        """
        Sets the block of this PlacementDetails.
        The block in the datacenter room where the resource was placed.


        :param block: The block of this PlacementDetails.
        :type: str
        """
        self._block = block

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
