# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531

from .odh_patching_config import OdhPatchingConfig
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DomainBasedOdhPatchingConfig(OdhPatchingConfig):
    """
    This patching config will patch all nodes in one AD/FD at a time.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DomainBasedOdhPatchingConfig object with values from keyword arguments. The default value of the :py:attr:`~oci.bds.models.DomainBasedOdhPatchingConfig.patching_config_strategy` attribute
        of this class is ``DOMAIN_BASED`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param patching_config_strategy:
            The value to assign to the patching_config_strategy property of this DomainBasedOdhPatchingConfig.
            Allowed values for this property are: "DOWNTIME_BASED", "BATCHING_BASED", "DOMAIN_BASED"
        :type patching_config_strategy: str

        :param wait_time_between_domain_in_seconds:
            The value to assign to the wait_time_between_domain_in_seconds property of this DomainBasedOdhPatchingConfig.
        :type wait_time_between_domain_in_seconds: int

        """
        self.swagger_types = {
            'patching_config_strategy': 'str',
            'wait_time_between_domain_in_seconds': 'int'
        }

        self.attribute_map = {
            'patching_config_strategy': 'patchingConfigStrategy',
            'wait_time_between_domain_in_seconds': 'waitTimeBetweenDomainInSeconds'
        }

        self._patching_config_strategy = None
        self._wait_time_between_domain_in_seconds = None
        self._patching_config_strategy = 'DOMAIN_BASED'

    @property
    def wait_time_between_domain_in_seconds(self):
        """
        **[Required]** Gets the wait_time_between_domain_in_seconds of this DomainBasedOdhPatchingConfig.
        The wait time between AD/FD in seconds.


        :return: The wait_time_between_domain_in_seconds of this DomainBasedOdhPatchingConfig.
        :rtype: int
        """
        return self._wait_time_between_domain_in_seconds

    @wait_time_between_domain_in_seconds.setter
    def wait_time_between_domain_in_seconds(self, wait_time_between_domain_in_seconds):
        """
        Sets the wait_time_between_domain_in_seconds of this DomainBasedOdhPatchingConfig.
        The wait time between AD/FD in seconds.


        :param wait_time_between_domain_in_seconds: The wait_time_between_domain_in_seconds of this DomainBasedOdhPatchingConfig.
        :type: int
        """
        self._wait_time_between_domain_in_seconds = wait_time_between_domain_in_seconds

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
