# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RealtimeMessageOut(object):
    """
    Websocket messages sent by client to the service.
    """

    #: A constant which can be used with the event property of a RealtimeMessageOut.
    #: This constant has a value of "SEND_FINAL_RESULT"
    EVENT_SEND_FINAL_RESULT = "SEND_FINAL_RESULT"

    def __init__(self, **kwargs):
        """
        Initializes a new RealtimeMessageOut object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.ai_speech.models.RealtimeMessageSendFinalResult`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param event:
            The value to assign to the event property of this RealtimeMessageOut.
            Allowed values for this property are: "SEND_FINAL_RESULT"
        :type event: str

        """
        self.swagger_types = {
            'event': 'str'
        }

        self.attribute_map = {
            'event': 'event'
        }

        self._event = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['event']

        if type == 'SEND_FINAL_RESULT':
            return 'RealtimeMessageSendFinalResult'
        else:
            return 'RealtimeMessageOut'

    @property
    def event(self):
        """
        **[Required]** Gets the event of this RealtimeMessageOut.
        Outgoing Types of message event sent from Client -> Service
        - SEND_FINAL_RESULT - sendFinalResult

        Allowed values for this property are: "SEND_FINAL_RESULT"


        :return: The event of this RealtimeMessageOut.
        :rtype: str
        """
        return self._event

    @event.setter
    def event(self, event):
        """
        Sets the event of this RealtimeMessageOut.
        Outgoing Types of message event sent from Client -> Service
        - SEND_FINAL_RESULT - sendFinalResult


        :param event: The event of this RealtimeMessageOut.
        :type: str
        """
        allowed_values = ["SEND_FINAL_RESULT"]
        if not value_allowed_none_or_none_sentinel(event, allowed_values):
            raise ValueError(
                f"Invalid value for `event`, must be None or one of {allowed_values}"
            )
        self._event = event

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
