# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RealtimeMessageAuthentication(object):
    """
    The payload for authentication.
    """

    #: A constant which can be used with the authentication_type property of a RealtimeMessageAuthentication.
    #: This constant has a value of "CREDENTIALS"
    AUTHENTICATION_TYPE_CREDENTIALS = "CREDENTIALS"

    #: A constant which can be used with the authentication_type property of a RealtimeMessageAuthentication.
    #: This constant has a value of "TOKEN"
    AUTHENTICATION_TYPE_TOKEN = "TOKEN"

    def __init__(self, **kwargs):
        """
        Initializes a new RealtimeMessageAuthentication object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.ai_speech.models.RealtimeMessageAuthenticationToken`
        * :class:`~oci.ai_speech.models.RealtimeMessageAuthenticationCredentials`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param authentication_type:
            The value to assign to the authentication_type property of this RealtimeMessageAuthentication.
            Allowed values for this property are: "CREDENTIALS", "TOKEN"
        :type authentication_type: str

        :param compartment_id:
            The value to assign to the compartment_id property of this RealtimeMessageAuthentication.
        :type compartment_id: str

        """
        self.swagger_types = {
            'authentication_type': 'str',
            'compartment_id': 'str'
        }

        self.attribute_map = {
            'authentication_type': 'authenticationType',
            'compartment_id': 'compartmentId'
        }

        self._authentication_type = None
        self._compartment_id = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['authenticationType']

        if type == 'TOKEN':
            return 'RealtimeMessageAuthenticationToken'

        if type == 'CREDENTIALS':
            return 'RealtimeMessageAuthenticationCredentials'
        else:
            return 'RealtimeMessageAuthentication'

    @property
    def authentication_type(self):
        """
        **[Required]** Gets the authentication_type of this RealtimeMessageAuthentication.
        Type of authentication method to be used.

        Allowed values for this property are: "CREDENTIALS", "TOKEN"


        :return: The authentication_type of this RealtimeMessageAuthentication.
        :rtype: str
        """
        return self._authentication_type

    @authentication_type.setter
    def authentication_type(self, authentication_type):
        """
        Sets the authentication_type of this RealtimeMessageAuthentication.
        Type of authentication method to be used.


        :param authentication_type: The authentication_type of this RealtimeMessageAuthentication.
        :type: str
        """
        allowed_values = ["CREDENTIALS", "TOKEN"]
        if not value_allowed_none_or_none_sentinel(authentication_type, allowed_values):
            raise ValueError(
                f"Invalid value for `authentication_type`, must be None or one of {allowed_values}"
            )
        self._authentication_type = authentication_type

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this RealtimeMessageAuthentication.
        Compartment ID to be used for authentication/authorization.


        :return: The compartment_id of this RealtimeMessageAuthentication.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this RealtimeMessageAuthentication.
        Compartment ID to be used for authentication/authorization.


        :param compartment_id: The compartment_id of this RealtimeMessageAuthentication.
        :type: str
        """
        self._compartment_id = compartment_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
