# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220101

from .realtime_message import RealtimeMessage
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RealtimeMessageAckAudio(RealtimeMessage):
    """
    The websocket ack message received from service.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RealtimeMessageAckAudio object with values from keyword arguments. The default value of the :py:attr:`~oci.ai_speech.models.RealtimeMessageAckAudio.event` attribute
        of this class is ``ACKAUDIO`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param event:
            The value to assign to the event property of this RealtimeMessageAckAudio.
            Allowed values for this property are: "RESULT", "ACKAUDIO", "ERROR", "CONNECT"
        :type event: str

        :param session_id:
            The value to assign to the session_id property of this RealtimeMessageAckAudio.
        :type session_id: str

        :param details:
            The value to assign to the details property of this RealtimeMessageAckAudio.
        :type details: oci.ai_speech.models.RealtimeMessageAckAudioDetails

        """
        self.swagger_types = {
            'event': 'str',
            'session_id': 'str',
            'details': 'RealtimeMessageAckAudioDetails'
        }

        self.attribute_map = {
            'event': 'event',
            'session_id': 'sessionId',
            'details': 'details'
        }

        self._event = None
        self._session_id = None
        self._details = None
        self._event = 'ACKAUDIO'

    @property
    def details(self):
        """
        **[Required]** Gets the details of this RealtimeMessageAckAudio.

        :return: The details of this RealtimeMessageAckAudio.
        :rtype: oci.ai_speech.models.RealtimeMessageAckAudioDetails
        """
        return self._details

    @details.setter
    def details(self, details):
        """
        Sets the details of this RealtimeMessageAckAudio.

        :param details: The details of this RealtimeMessageAckAudio.
        :type: oci.ai_speech.models.RealtimeMessageAckAudioDetails
        """
        self._details = details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
