# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181116


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ProtectionRuleAction(object):
    """
    A protection rule key and the associated action to apply to that rule.
    """

    #: A constant which can be used with the action property of a ProtectionRuleAction.
    #: This constant has a value of "OFF"
    ACTION_OFF = "OFF"

    #: A constant which can be used with the action property of a ProtectionRuleAction.
    #: This constant has a value of "DETECT"
    ACTION_DETECT = "DETECT"

    #: A constant which can be used with the action property of a ProtectionRuleAction.
    #: This constant has a value of "BLOCK"
    ACTION_BLOCK = "BLOCK"

    def __init__(self, **kwargs):
        """
        Initializes a new ProtectionRuleAction object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param key:
            The value to assign to the key property of this ProtectionRuleAction.
        :type key: str

        :param action:
            The value to assign to the action property of this ProtectionRuleAction.
            Allowed values for this property are: "OFF", "DETECT", "BLOCK"
        :type action: str

        :param exclusions:
            The value to assign to the exclusions property of this ProtectionRuleAction.
        :type exclusions: list[oci.waas.models.ProtectionRuleExclusion]

        """
        self.swagger_types = {
            'key': 'str',
            'action': 'str',
            'exclusions': 'list[ProtectionRuleExclusion]'
        }

        self.attribute_map = {
            'key': 'key',
            'action': 'action',
            'exclusions': 'exclusions'
        }

        self._key = None
        self._action = None
        self._exclusions = None

    @property
    def key(self):
        """
        **[Required]** Gets the key of this ProtectionRuleAction.
        The unique key of the protection rule.


        :return: The key of this ProtectionRuleAction.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """
        Sets the key of this ProtectionRuleAction.
        The unique key of the protection rule.


        :param key: The key of this ProtectionRuleAction.
        :type: str
        """
        self._key = key

    @property
    def action(self):
        """
        **[Required]** Gets the action of this ProtectionRuleAction.
        The action to apply to the protection rule. If unspecified, defaults to `OFF`.

        Allowed values for this property are: "OFF", "DETECT", "BLOCK"


        :return: The action of this ProtectionRuleAction.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """
        Sets the action of this ProtectionRuleAction.
        The action to apply to the protection rule. If unspecified, defaults to `OFF`.


        :param action: The action of this ProtectionRuleAction.
        :type: str
        """
        allowed_values = ["OFF", "DETECT", "BLOCK"]
        if not value_allowed_none_or_none_sentinel(action, allowed_values):
            raise ValueError(
                f"Invalid value for `action`, must be None or one of {allowed_values}"
            )
        self._action = action

    @property
    def exclusions(self):
        """
        Gets the exclusions of this ProtectionRuleAction.
        The types of requests excluded from the protection rule action. If the requests matches the criteria in the `exclusions`, the protection rule action will not be executed.


        :return: The exclusions of this ProtectionRuleAction.
        :rtype: list[oci.waas.models.ProtectionRuleExclusion]
        """
        return self._exclusions

    @exclusions.setter
    def exclusions(self, exclusions):
        """
        Sets the exclusions of this ProtectionRuleAction.
        The types of requests excluded from the protection rule action. If the requests matches the criteria in the `exclusions`, the protection rule action will not be executed.


        :param exclusions: The exclusions of this ProtectionRuleAction.
        :type: list[oci.waas.models.ProtectionRuleExclusion]
        """
        self._exclusions = exclusions

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
