# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210215


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HostEndpointProtectionScanResult(object):
    """
    A scan result for a host endpoint protection scan
    """

    #: A constant which can be used with the problem_severity property of a HostEndpointProtectionScanResult.
    #: This constant has a value of "NONE"
    PROBLEM_SEVERITY_NONE = "NONE"

    #: A constant which can be used with the problem_severity property of a HostEndpointProtectionScanResult.
    #: This constant has a value of "LOW"
    PROBLEM_SEVERITY_LOW = "LOW"

    #: A constant which can be used with the problem_severity property of a HostEndpointProtectionScanResult.
    #: This constant has a value of "MEDIUM"
    PROBLEM_SEVERITY_MEDIUM = "MEDIUM"

    #: A constant which can be used with the problem_severity property of a HostEndpointProtectionScanResult.
    #: This constant has a value of "HIGH"
    PROBLEM_SEVERITY_HIGH = "HIGH"

    #: A constant which can be used with the problem_severity property of a HostEndpointProtectionScanResult.
    #: This constant has a value of "CRITICAL"
    PROBLEM_SEVERITY_CRITICAL = "CRITICAL"

    #: A constant which can be used with the lifecycle_state property of a HostEndpointProtectionScanResult.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a HostEndpointProtectionScanResult.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a HostEndpointProtectionScanResult.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a HostEndpointProtectionScanResult.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a HostEndpointProtectionScanResult.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a HostEndpointProtectionScanResult.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new HostEndpointProtectionScanResult object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this HostEndpointProtectionScanResult.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this HostEndpointProtectionScanResult.
        :type display_name: str

        :param instance_id:
            The value to assign to the instance_id property of this HostEndpointProtectionScanResult.
        :type instance_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this HostEndpointProtectionScanResult.
        :type compartment_id: str

        :param time_started:
            The value to assign to the time_started property of this HostEndpointProtectionScanResult.
        :type time_started: datetime

        :param time_finished:
            The value to assign to the time_finished property of this HostEndpointProtectionScanResult.
        :type time_finished: datetime

        :param problem_severity:
            The value to assign to the problem_severity property of this HostEndpointProtectionScanResult.
            Allowed values for this property are: "NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type problem_severity: str

        :param endpoint_protections_count:
            The value to assign to the endpoint_protections_count property of this HostEndpointProtectionScanResult.
        :type endpoint_protections_count: int

        :param endpoint_protections:
            The value to assign to the endpoint_protections property of this HostEndpointProtectionScanResult.
        :type endpoint_protections: list[oci.vulnerability_scanning.models.HostEndpointProtectionScanResultEndpointProtection]

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this HostEndpointProtectionScanResult.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'instance_id': 'str',
            'compartment_id': 'str',
            'time_started': 'datetime',
            'time_finished': 'datetime',
            'problem_severity': 'str',
            'endpoint_protections_count': 'int',
            'endpoint_protections': 'list[HostEndpointProtectionScanResultEndpointProtection]',
            'lifecycle_state': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'instance_id': 'instanceId',
            'compartment_id': 'compartmentId',
            'time_started': 'timeStarted',
            'time_finished': 'timeFinished',
            'problem_severity': 'problemSeverity',
            'endpoint_protections_count': 'endpointProtectionsCount',
            'endpoint_protections': 'endpointProtections',
            'lifecycle_state': 'lifecycleState'
        }

        self._id = None
        self._display_name = None
        self._instance_id = None
        self._compartment_id = None
        self._time_started = None
        self._time_finished = None
        self._problem_severity = None
        self._endpoint_protections_count = None
        self._endpoint_protections = None
        self._lifecycle_state = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this HostEndpointProtectionScanResult.
        Unique identifier of the scan


        :return: The id of this HostEndpointProtectionScanResult.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this HostEndpointProtectionScanResult.
        Unique identifier of the scan


        :param id: The id of this HostEndpointProtectionScanResult.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this HostEndpointProtectionScanResult.
        Name of the resource


        :return: The display_name of this HostEndpointProtectionScanResult.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this HostEndpointProtectionScanResult.
        Name of the resource


        :param display_name: The display_name of this HostEndpointProtectionScanResult.
        :type: str
        """
        self._display_name = display_name

    @property
    def instance_id(self):
        """
        **[Required]** Gets the instance_id of this HostEndpointProtectionScanResult.
        Instance ID of the Compute Instance scanned


        :return: The instance_id of this HostEndpointProtectionScanResult.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this HostEndpointProtectionScanResult.
        Instance ID of the Compute Instance scanned


        :param instance_id: The instance_id of this HostEndpointProtectionScanResult.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this HostEndpointProtectionScanResult.
        Compartment ID of the resource. This is set to the same as the compartment ID of the scan target


        :return: The compartment_id of this HostEndpointProtectionScanResult.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this HostEndpointProtectionScanResult.
        Compartment ID of the resource. This is set to the same as the compartment ID of the scan target


        :param compartment_id: The compartment_id of this HostEndpointProtectionScanResult.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def time_started(self):
        """
        **[Required]** Gets the time_started of this HostEndpointProtectionScanResult.
        Date and time the scan was started, as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_started of this HostEndpointProtectionScanResult.
        :rtype: datetime
        """
        return self._time_started

    @time_started.setter
    def time_started(self, time_started):
        """
        Sets the time_started of this HostEndpointProtectionScanResult.
        Date and time the scan was started, as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_started: The time_started of this HostEndpointProtectionScanResult.
        :type: datetime
        """
        self._time_started = time_started

    @property
    def time_finished(self):
        """
        **[Required]** Gets the time_finished of this HostEndpointProtectionScanResult.
        Date and time the scan was completed, as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_finished of this HostEndpointProtectionScanResult.
        :rtype: datetime
        """
        return self._time_finished

    @time_finished.setter
    def time_finished(self, time_finished):
        """
        Sets the time_finished of this HostEndpointProtectionScanResult.
        Date and time the scan was completed, as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_finished: The time_finished of this HostEndpointProtectionScanResult.
        :type: datetime
        """
        self._time_finished = time_finished

    @property
    def problem_severity(self):
        """
        **[Required]** Gets the problem_severity of this HostEndpointProtectionScanResult.
        Problem severity in this report

        Allowed values for this property are: "NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The problem_severity of this HostEndpointProtectionScanResult.
        :rtype: str
        """
        return self._problem_severity

    @problem_severity.setter
    def problem_severity(self, problem_severity):
        """
        Sets the problem_severity of this HostEndpointProtectionScanResult.
        Problem severity in this report


        :param problem_severity: The problem_severity of this HostEndpointProtectionScanResult.
        :type: str
        """
        allowed_values = ["NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL"]
        if not value_allowed_none_or_none_sentinel(problem_severity, allowed_values):
            problem_severity = 'UNKNOWN_ENUM_VALUE'
        self._problem_severity = problem_severity

    @property
    def endpoint_protections_count(self):
        """
        **[Required]** Gets the endpoint_protections_count of this HostEndpointProtectionScanResult.
        Total number of endpoint protections found in this scan


        :return: The endpoint_protections_count of this HostEndpointProtectionScanResult.
        :rtype: int
        """
        return self._endpoint_protections_count

    @endpoint_protections_count.setter
    def endpoint_protections_count(self, endpoint_protections_count):
        """
        Sets the endpoint_protections_count of this HostEndpointProtectionScanResult.
        Total number of endpoint protections found in this scan


        :param endpoint_protections_count: The endpoint_protections_count of this HostEndpointProtectionScanResult.
        :type: int
        """
        self._endpoint_protections_count = endpoint_protections_count

    @property
    def endpoint_protections(self):
        """
        **[Required]** Gets the endpoint_protections of this HostEndpointProtectionScanResult.
        List of endpoint protections found in this scan


        :return: The endpoint_protections of this HostEndpointProtectionScanResult.
        :rtype: list[oci.vulnerability_scanning.models.HostEndpointProtectionScanResultEndpointProtection]
        """
        return self._endpoint_protections

    @endpoint_protections.setter
    def endpoint_protections(self, endpoint_protections):
        """
        Sets the endpoint_protections of this HostEndpointProtectionScanResult.
        List of endpoint protections found in this scan


        :param endpoint_protections: The endpoint_protections of this HostEndpointProtectionScanResult.
        :type: list[oci.vulnerability_scanning.models.HostEndpointProtectionScanResultEndpointProtection]
        """
        self._endpoint_protections = endpoint_protections

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this HostEndpointProtectionScanResult.
        The current state of the result.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this HostEndpointProtectionScanResult.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this HostEndpointProtectionScanResult.
        The current state of the result.


        :param lifecycle_state: The lifecycle_state of this HostEndpointProtectionScanResult.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
