# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210215


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HostAgentScanResult(object):
    """
    A scan result for a host agent scan
    """

    #: A constant which can be used with the highest_problem_severity property of a HostAgentScanResult.
    #: This constant has a value of "NONE"
    HIGHEST_PROBLEM_SEVERITY_NONE = "NONE"

    #: A constant which can be used with the highest_problem_severity property of a HostAgentScanResult.
    #: This constant has a value of "LOW"
    HIGHEST_PROBLEM_SEVERITY_LOW = "LOW"

    #: A constant which can be used with the highest_problem_severity property of a HostAgentScanResult.
    #: This constant has a value of "MEDIUM"
    HIGHEST_PROBLEM_SEVERITY_MEDIUM = "MEDIUM"

    #: A constant which can be used with the highest_problem_severity property of a HostAgentScanResult.
    #: This constant has a value of "HIGH"
    HIGHEST_PROBLEM_SEVERITY_HIGH = "HIGH"

    #: A constant which can be used with the highest_problem_severity property of a HostAgentScanResult.
    #: This constant has a value of "CRITICAL"
    HIGHEST_PROBLEM_SEVERITY_CRITICAL = "CRITICAL"

    #: A constant which can be used with the lifecycle_state property of a HostAgentScanResult.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a HostAgentScanResult.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a HostAgentScanResult.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a HostAgentScanResult.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a HostAgentScanResult.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a HostAgentScanResult.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the vendor property of a HostAgentScanResult.
    #: This constant has a value of "OCI"
    VENDOR_OCI = "OCI"

    #: A constant which can be used with the vendor property of a HostAgentScanResult.
    #: This constant has a value of "QUALYS"
    VENDOR_QUALYS = "QUALYS"

    def __init__(self, **kwargs):
        """
        Initializes a new HostAgentScanResult object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this HostAgentScanResult.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this HostAgentScanResult.
        :type display_name: str

        :param instance_id:
            The value to assign to the instance_id property of this HostAgentScanResult.
        :type instance_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this HostAgentScanResult.
        :type compartment_id: str

        :param highest_problem_severity:
            The value to assign to the highest_problem_severity property of this HostAgentScanResult.
            Allowed values for this property are: "NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type highest_problem_severity: str

        :param operating_system:
            The value to assign to the operating_system property of this HostAgentScanResult.
        :type operating_system: str

        :param kernel_version:
            The value to assign to the kernel_version property of this HostAgentScanResult.
        :type kernel_version: str

        :param problem_count:
            The value to assign to the problem_count property of this HostAgentScanResult.
        :type problem_count: int

        :param time_started:
            The value to assign to the time_started property of this HostAgentScanResult.
        :type time_started: datetime

        :param time_finished:
            The value to assign to the time_finished property of this HostAgentScanResult.
        :type time_finished: datetime

        :param problems:
            The value to assign to the problems property of this HostAgentScanResult.
        :type problems: list[oci.vulnerability_scanning.models.HostAgentScanResultProblem]

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this HostAgentScanResult.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param vendor:
            The value to assign to the vendor property of this HostAgentScanResult.
            Allowed values for this property are: "OCI", "QUALYS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type vendor: str

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'instance_id': 'str',
            'compartment_id': 'str',
            'highest_problem_severity': 'str',
            'operating_system': 'str',
            'kernel_version': 'str',
            'problem_count': 'int',
            'time_started': 'datetime',
            'time_finished': 'datetime',
            'problems': 'list[HostAgentScanResultProblem]',
            'lifecycle_state': 'str',
            'vendor': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'instance_id': 'instanceId',
            'compartment_id': 'compartmentId',
            'highest_problem_severity': 'highestProblemSeverity',
            'operating_system': 'operatingSystem',
            'kernel_version': 'kernelVersion',
            'problem_count': 'problemCount',
            'time_started': 'timeStarted',
            'time_finished': 'timeFinished',
            'problems': 'problems',
            'lifecycle_state': 'lifecycleState',
            'vendor': 'vendor'
        }

        self._id = None
        self._display_name = None
        self._instance_id = None
        self._compartment_id = None
        self._highest_problem_severity = None
        self._operating_system = None
        self._kernel_version = None
        self._problem_count = None
        self._time_started = None
        self._time_finished = None
        self._problems = None
        self._lifecycle_state = None
        self._vendor = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this HostAgentScanResult.
        Unique identifier of the scan


        :return: The id of this HostAgentScanResult.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this HostAgentScanResult.
        Unique identifier of the scan


        :param id: The id of this HostAgentScanResult.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this HostAgentScanResult.
        Name of the resource


        :return: The display_name of this HostAgentScanResult.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this HostAgentScanResult.
        Name of the resource


        :param display_name: The display_name of this HostAgentScanResult.
        :type: str
        """
        self._display_name = display_name

    @property
    def instance_id(self):
        """
        **[Required]** Gets the instance_id of this HostAgentScanResult.
        Instance ID of the Compute Instance scanned


        :return: The instance_id of this HostAgentScanResult.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this HostAgentScanResult.
        Instance ID of the Compute Instance scanned


        :param instance_id: The instance_id of this HostAgentScanResult.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this HostAgentScanResult.
        Compartment ID of the resource. This is set to the same as the compartment ID of the scan target


        :return: The compartment_id of this HostAgentScanResult.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this HostAgentScanResult.
        Compartment ID of the resource. This is set to the same as the compartment ID of the scan target


        :param compartment_id: The compartment_id of this HostAgentScanResult.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def highest_problem_severity(self):
        """
        **[Required]** Gets the highest_problem_severity of this HostAgentScanResult.
        Highest problem severity in this report

        Allowed values for this property are: "NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The highest_problem_severity of this HostAgentScanResult.
        :rtype: str
        """
        return self._highest_problem_severity

    @highest_problem_severity.setter
    def highest_problem_severity(self, highest_problem_severity):
        """
        Sets the highest_problem_severity of this HostAgentScanResult.
        Highest problem severity in this report


        :param highest_problem_severity: The highest_problem_severity of this HostAgentScanResult.
        :type: str
        """
        allowed_values = ["NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL"]
        if not value_allowed_none_or_none_sentinel(highest_problem_severity, allowed_values):
            highest_problem_severity = 'UNKNOWN_ENUM_VALUE'
        self._highest_problem_severity = highest_problem_severity

    @property
    def operating_system(self):
        """
        **[Required]** Gets the operating_system of this HostAgentScanResult.
        Operating system of the host


        :return: The operating_system of this HostAgentScanResult.
        :rtype: str
        """
        return self._operating_system

    @operating_system.setter
    def operating_system(self, operating_system):
        """
        Sets the operating_system of this HostAgentScanResult.
        Operating system of the host


        :param operating_system: The operating_system of this HostAgentScanResult.
        :type: str
        """
        self._operating_system = operating_system

    @property
    def kernel_version(self):
        """
        Gets the kernel_version of this HostAgentScanResult.
        Kernel version of the operating system


        :return: The kernel_version of this HostAgentScanResult.
        :rtype: str
        """
        return self._kernel_version

    @kernel_version.setter
    def kernel_version(self, kernel_version):
        """
        Sets the kernel_version of this HostAgentScanResult.
        Kernel version of the operating system


        :param kernel_version: The kernel_version of this HostAgentScanResult.
        :type: str
        """
        self._kernel_version = kernel_version

    @property
    def problem_count(self):
        """
        Gets the problem_count of this HostAgentScanResult.
        Total number of problems found in this scan


        :return: The problem_count of this HostAgentScanResult.
        :rtype: int
        """
        return self._problem_count

    @problem_count.setter
    def problem_count(self, problem_count):
        """
        Sets the problem_count of this HostAgentScanResult.
        Total number of problems found in this scan


        :param problem_count: The problem_count of this HostAgentScanResult.
        :type: int
        """
        self._problem_count = problem_count

    @property
    def time_started(self):
        """
        **[Required]** Gets the time_started of this HostAgentScanResult.
        Date and time the scan was started, as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_started of this HostAgentScanResult.
        :rtype: datetime
        """
        return self._time_started

    @time_started.setter
    def time_started(self, time_started):
        """
        Sets the time_started of this HostAgentScanResult.
        Date and time the scan was started, as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_started: The time_started of this HostAgentScanResult.
        :type: datetime
        """
        self._time_started = time_started

    @property
    def time_finished(self):
        """
        **[Required]** Gets the time_finished of this HostAgentScanResult.
        Date and time the scan was completed, as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_finished of this HostAgentScanResult.
        :rtype: datetime
        """
        return self._time_finished

    @time_finished.setter
    def time_finished(self, time_finished):
        """
        Sets the time_finished of this HostAgentScanResult.
        Date and time the scan was completed, as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_finished: The time_finished of this HostAgentScanResult.
        :type: datetime
        """
        self._time_finished = time_finished

    @property
    def problems(self):
        """
        **[Required]** Gets the problems of this HostAgentScanResult.
        List of problems found in this scan


        :return: The problems of this HostAgentScanResult.
        :rtype: list[oci.vulnerability_scanning.models.HostAgentScanResultProblem]
        """
        return self._problems

    @problems.setter
    def problems(self, problems):
        """
        Sets the problems of this HostAgentScanResult.
        List of problems found in this scan


        :param problems: The problems of this HostAgentScanResult.
        :type: list[oci.vulnerability_scanning.models.HostAgentScanResultProblem]
        """
        self._problems = problems

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this HostAgentScanResult.
        The current state of the result.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this HostAgentScanResult.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this HostAgentScanResult.
        The current state of the result.


        :param lifecycle_state: The lifecycle_state of this HostAgentScanResult.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def vendor(self):
        """
        Gets the vendor of this HostAgentScanResult.
        Vendor which was used for this host scan agent.

        Allowed values for this property are: "OCI", "QUALYS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The vendor of this HostAgentScanResult.
        :rtype: str
        """
        return self._vendor

    @vendor.setter
    def vendor(self, vendor):
        """
        Sets the vendor of this HostAgentScanResult.
        Vendor which was used for this host scan agent.


        :param vendor: The vendor of this HostAgentScanResult.
        :type: str
        """
        allowed_values = ["OCI", "QUALYS"]
        if not value_allowed_none_or_none_sentinel(vendor, allowed_values):
            vendor = 'UNKNOWN_ENUM_VALUE'
        self._vendor = vendor

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
