# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateMaintenanceWindowResourceDetails(object):
    """
    List of resource IDs that are part of the Maintenance Window.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateMaintenanceWindowResourceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param resource_id:
            The value to assign to the resource_id property of this CreateMaintenanceWindowResourceDetails.
        :type resource_id: str

        :param are_members_included:
            The value to assign to the are_members_included property of this CreateMaintenanceWindowResourceDetails.
        :type are_members_included: bool

        """
        self.swagger_types = {
            'resource_id': 'str',
            'are_members_included': 'bool'
        }

        self.attribute_map = {
            'resource_id': 'resourceId',
            'are_members_included': 'areMembersIncluded'
        }

        self._resource_id = None
        self._are_members_included = None

    @property
    def resource_id(self):
        """
        **[Required]** Gets the resource_id of this CreateMaintenanceWindowResourceDetails.
        The `OCID`__ of monitored resource
        part of the Maintenance window.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The resource_id of this CreateMaintenanceWindowResourceDetails.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this CreateMaintenanceWindowResourceDetails.
        The `OCID`__ of monitored resource
        part of the Maintenance window.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param resource_id: The resource_id of this CreateMaintenanceWindowResourceDetails.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def are_members_included(self):
        """
        Gets the are_members_included of this CreateMaintenanceWindowResourceDetails.
        Flag to indicate if the members of the resource has to be include in the
        Maintenance Window.


        :return: The are_members_included of this CreateMaintenanceWindowResourceDetails.
        :rtype: bool
        """
        return self._are_members_included

    @are_members_included.setter
    def are_members_included(self, are_members_included):
        """
        Sets the are_members_included of this CreateMaintenanceWindowResourceDetails.
        Flag to indicate if the members of the resource has to be include in the
        Maintenance Window.


        :param are_members_included: The are_members_included of this CreateMaintenanceWindowResourceDetails.
        :type: bool
        """
        self._are_members_included = are_members_included

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
