# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ScheduledJobSummary(object):
    """
    Provides summary information for a scheduled job.
    """

    #: A constant which can be used with the schedule_type property of a ScheduledJobSummary.
    #: This constant has a value of "ONETIME"
    SCHEDULE_TYPE_ONETIME = "ONETIME"

    #: A constant which can be used with the schedule_type property of a ScheduledJobSummary.
    #: This constant has a value of "RECURRING"
    SCHEDULE_TYPE_RECURRING = "RECURRING"

    def __init__(self, **kwargs):
        """
        Initializes a new ScheduledJobSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ScheduledJobSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this ScheduledJobSummary.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ScheduledJobSummary.
        :type compartment_id: str

        :param schedule_type:
            The value to assign to the schedule_type property of this ScheduledJobSummary.
            Allowed values for this property are: "ONETIME", "RECURRING", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type schedule_type: str

        :param locations:
            The value to assign to the locations property of this ScheduledJobSummary.
        :type locations: list[oci.os_management_hub.models.ManagedInstanceLocation]

        :param time_created:
            The value to assign to the time_created property of this ScheduledJobSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this ScheduledJobSummary.
        :type time_updated: datetime

        :param time_next_execution:
            The value to assign to the time_next_execution property of this ScheduledJobSummary.
        :type time_next_execution: datetime

        :param time_last_execution:
            The value to assign to the time_last_execution property of this ScheduledJobSummary.
        :type time_last_execution: datetime

        :param managed_instance_ids:
            The value to assign to the managed_instance_ids property of this ScheduledJobSummary.
        :type managed_instance_ids: list[str]

        :param managed_instance_group_ids:
            The value to assign to the managed_instance_group_ids property of this ScheduledJobSummary.
        :type managed_instance_group_ids: list[str]

        :param managed_compartment_ids:
            The value to assign to the managed_compartment_ids property of this ScheduledJobSummary.
        :type managed_compartment_ids: list[str]

        :param lifecycle_stage_ids:
            The value to assign to the lifecycle_stage_ids property of this ScheduledJobSummary.
        :type lifecycle_stage_ids: list[str]

        :param operations:
            The value to assign to the operations property of this ScheduledJobSummary.
        :type operations: list[oci.os_management_hub.models.ScheduledJobOperation]

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ScheduledJobSummary.
        :type lifecycle_state: str

        :param is_managed_by_autonomous_linux:
            The value to assign to the is_managed_by_autonomous_linux property of this ScheduledJobSummary.
        :type is_managed_by_autonomous_linux: bool

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ScheduledJobSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ScheduledJobSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this ScheduledJobSummary.
        :type system_tags: dict(str, dict(str, object))

        :param is_restricted:
            The value to assign to the is_restricted property of this ScheduledJobSummary.
        :type is_restricted: bool

        :param retry_intervals:
            The value to assign to the retry_intervals property of this ScheduledJobSummary.
        :type retry_intervals: list[int]

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'schedule_type': 'str',
            'locations': 'list[ManagedInstanceLocation]',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'time_next_execution': 'datetime',
            'time_last_execution': 'datetime',
            'managed_instance_ids': 'list[str]',
            'managed_instance_group_ids': 'list[str]',
            'managed_compartment_ids': 'list[str]',
            'lifecycle_stage_ids': 'list[str]',
            'operations': 'list[ScheduledJobOperation]',
            'lifecycle_state': 'str',
            'is_managed_by_autonomous_linux': 'bool',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'is_restricted': 'bool',
            'retry_intervals': 'list[int]'
        }

        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'schedule_type': 'scheduleType',
            'locations': 'locations',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'time_next_execution': 'timeNextExecution',
            'time_last_execution': 'timeLastExecution',
            'managed_instance_ids': 'managedInstanceIds',
            'managed_instance_group_ids': 'managedInstanceGroupIds',
            'managed_compartment_ids': 'managedCompartmentIds',
            'lifecycle_stage_ids': 'lifecycleStageIds',
            'operations': 'operations',
            'lifecycle_state': 'lifecycleState',
            'is_managed_by_autonomous_linux': 'isManagedByAutonomousLinux',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'is_restricted': 'isRestricted',
            'retry_intervals': 'retryIntervals'
        }

        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._schedule_type = None
        self._locations = None
        self._time_created = None
        self._time_updated = None
        self._time_next_execution = None
        self._time_last_execution = None
        self._managed_instance_ids = None
        self._managed_instance_group_ids = None
        self._managed_compartment_ids = None
        self._lifecycle_stage_ids = None
        self._operations = None
        self._lifecycle_state = None
        self._is_managed_by_autonomous_linux = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._is_restricted = None
        self._retry_intervals = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ScheduledJobSummary.
        The `OCID`__ of the scheduled job.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this ScheduledJobSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ScheduledJobSummary.
        The `OCID`__ of the scheduled job.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this ScheduledJobSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this ScheduledJobSummary.
        User-friendly name for the scheduled job.


        :return: The display_name of this ScheduledJobSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ScheduledJobSummary.
        User-friendly name for the scheduled job.


        :param display_name: The display_name of this ScheduledJobSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ScheduledJobSummary.
        The `OCID`__ of the compartment that contains the scheduled job.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this ScheduledJobSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ScheduledJobSummary.
        The `OCID`__ of the compartment that contains the scheduled job.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this ScheduledJobSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def schedule_type(self):
        """
        **[Required]** Gets the schedule_type of this ScheduledJobSummary.
        The type of scheduling this scheduled job follows.

        Allowed values for this property are: "ONETIME", "RECURRING", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The schedule_type of this ScheduledJobSummary.
        :rtype: str
        """
        return self._schedule_type

    @schedule_type.setter
    def schedule_type(self, schedule_type):
        """
        Sets the schedule_type of this ScheduledJobSummary.
        The type of scheduling this scheduled job follows.


        :param schedule_type: The schedule_type of this ScheduledJobSummary.
        :type: str
        """
        allowed_values = ["ONETIME", "RECURRING"]
        if not value_allowed_none_or_none_sentinel(schedule_type, allowed_values):
            schedule_type = 'UNKNOWN_ENUM_VALUE'
        self._schedule_type = schedule_type

    @property
    def locations(self):
        """
        Gets the locations of this ScheduledJobSummary.
        The list of locations this scheduled job should operate on for a job targeting on compartments. (Empty list means apply to all locations). This can only be set when managedCompartmentIds is not empty.


        :return: The locations of this ScheduledJobSummary.
        :rtype: list[oci.os_management_hub.models.ManagedInstanceLocation]
        """
        return self._locations

    @locations.setter
    def locations(self, locations):
        """
        Sets the locations of this ScheduledJobSummary.
        The list of locations this scheduled job should operate on for a job targeting on compartments. (Empty list means apply to all locations). This can only be set when managedCompartmentIds is not empty.


        :param locations: The locations of this ScheduledJobSummary.
        :type: list[oci.os_management_hub.models.ManagedInstanceLocation]
        """
        self._locations = locations

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this ScheduledJobSummary.
        The time this scheduled job was created (in `RFC 3339`__ format).

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_created of this ScheduledJobSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ScheduledJobSummary.
        The time this scheduled job was created (in `RFC 3339`__ format).

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_created: The time_created of this ScheduledJobSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this ScheduledJobSummary.
        The time this scheduled job was updated (in `RFC 3339`__ format).

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_updated of this ScheduledJobSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this ScheduledJobSummary.
        The time this scheduled job was updated (in `RFC 3339`__ format).

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_updated: The time_updated of this ScheduledJobSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def time_next_execution(self):
        """
        **[Required]** Gets the time_next_execution of this ScheduledJobSummary.
        The time of the next execution of this scheduled job (in `RFC 3339`__ format).

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_next_execution of this ScheduledJobSummary.
        :rtype: datetime
        """
        return self._time_next_execution

    @time_next_execution.setter
    def time_next_execution(self, time_next_execution):
        """
        Sets the time_next_execution of this ScheduledJobSummary.
        The time of the next execution of this scheduled job (in `RFC 3339`__ format).

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_next_execution: The time_next_execution of this ScheduledJobSummary.
        :type: datetime
        """
        self._time_next_execution = time_next_execution

    @property
    def time_last_execution(self):
        """
        Gets the time_last_execution of this ScheduledJobSummary.
        The time of the last execution of this scheduled job (in `RFC 3339`__ format).b.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_last_execution of this ScheduledJobSummary.
        :rtype: datetime
        """
        return self._time_last_execution

    @time_last_execution.setter
    def time_last_execution(self, time_last_execution):
        """
        Sets the time_last_execution of this ScheduledJobSummary.
        The time of the last execution of this scheduled job (in `RFC 3339`__ format).b.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_last_execution: The time_last_execution of this ScheduledJobSummary.
        :type: datetime
        """
        self._time_last_execution = time_last_execution

    @property
    def managed_instance_ids(self):
        """
        Gets the managed_instance_ids of this ScheduledJobSummary.
        The managed instance `OCIDs`__ that this scheduled job operates on.
        A scheduled job can only operate on one type of target, therefore this parameter is mutually exclusive with
        managedInstanceGroupIds, managedCompartmentIds, and lifecycleStageIds.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The managed_instance_ids of this ScheduledJobSummary.
        :rtype: list[str]
        """
        return self._managed_instance_ids

    @managed_instance_ids.setter
    def managed_instance_ids(self, managed_instance_ids):
        """
        Sets the managed_instance_ids of this ScheduledJobSummary.
        The managed instance `OCIDs`__ that this scheduled job operates on.
        A scheduled job can only operate on one type of target, therefore this parameter is mutually exclusive with
        managedInstanceGroupIds, managedCompartmentIds, and lifecycleStageIds.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param managed_instance_ids: The managed_instance_ids of this ScheduledJobSummary.
        :type: list[str]
        """
        self._managed_instance_ids = managed_instance_ids

    @property
    def managed_instance_group_ids(self):
        """
        Gets the managed_instance_group_ids of this ScheduledJobSummary.
        The managed instance group `OCIDs`__ that this scheduled job operates on.
        A scheduled job can only operate on one type of target, therefore this parameter is mutually exclusive with
        managedInstanceIds, managedCompartmentIds, and lifecycleStageIds.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The managed_instance_group_ids of this ScheduledJobSummary.
        :rtype: list[str]
        """
        return self._managed_instance_group_ids

    @managed_instance_group_ids.setter
    def managed_instance_group_ids(self, managed_instance_group_ids):
        """
        Sets the managed_instance_group_ids of this ScheduledJobSummary.
        The managed instance group `OCIDs`__ that this scheduled job operates on.
        A scheduled job can only operate on one type of target, therefore this parameter is mutually exclusive with
        managedInstanceIds, managedCompartmentIds, and lifecycleStageIds.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param managed_instance_group_ids: The managed_instance_group_ids of this ScheduledJobSummary.
        :type: list[str]
        """
        self._managed_instance_group_ids = managed_instance_group_ids

    @property
    def managed_compartment_ids(self):
        """
        Gets the managed_compartment_ids of this ScheduledJobSummary.
        The compartment `OCIDs`__ that this scheduled job operates on.
        A scheduled job can only operate on one type of target, therefore this parameter is mutually exclusive with
        managedInstanceIds, managedInstanceGroupIds, and lifecycleStageIds.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The managed_compartment_ids of this ScheduledJobSummary.
        :rtype: list[str]
        """
        return self._managed_compartment_ids

    @managed_compartment_ids.setter
    def managed_compartment_ids(self, managed_compartment_ids):
        """
        Sets the managed_compartment_ids of this ScheduledJobSummary.
        The compartment `OCIDs`__ that this scheduled job operates on.
        A scheduled job can only operate on one type of target, therefore this parameter is mutually exclusive with
        managedInstanceIds, managedInstanceGroupIds, and lifecycleStageIds.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param managed_compartment_ids: The managed_compartment_ids of this ScheduledJobSummary.
        :type: list[str]
        """
        self._managed_compartment_ids = managed_compartment_ids

    @property
    def lifecycle_stage_ids(self):
        """
        Gets the lifecycle_stage_ids of this ScheduledJobSummary.
        The lifecycle stage `OCIDs`__ that this scheduled job operates on.
        A scheduled job can only operate on one type of target, therefore this parameter is mutually exclusive with
        managedInstanceIds, managedInstanceGroupIds, and managedCompartmentIds.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The lifecycle_stage_ids of this ScheduledJobSummary.
        :rtype: list[str]
        """
        return self._lifecycle_stage_ids

    @lifecycle_stage_ids.setter
    def lifecycle_stage_ids(self, lifecycle_stage_ids):
        """
        Sets the lifecycle_stage_ids of this ScheduledJobSummary.
        The lifecycle stage `OCIDs`__ that this scheduled job operates on.
        A scheduled job can only operate on one type of target, therefore this parameter is mutually exclusive with
        managedInstanceIds, managedInstanceGroupIds, and managedCompartmentIds.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param lifecycle_stage_ids: The lifecycle_stage_ids of this ScheduledJobSummary.
        :type: list[str]
        """
        self._lifecycle_stage_ids = lifecycle_stage_ids

    @property
    def operations(self):
        """
        **[Required]** Gets the operations of this ScheduledJobSummary.
        The list of operations this scheduled job needs to perform.
        A scheduled job supports only one operation type, unless it is one of the following:
        * UPDATE_PACKAGES
        * UPDATE_ALL
        * UPDATE_SECURITY
        * UPDATE_BUGFIX
        * UPDATE_ENHANCEMENT
        * UPDATE_OTHER
        * UPDATE_KSPLICE_USERSPACE
        * UPDATE_KSPLICE_KERNEL


        :return: The operations of this ScheduledJobSummary.
        :rtype: list[oci.os_management_hub.models.ScheduledJobOperation]
        """
        return self._operations

    @operations.setter
    def operations(self, operations):
        """
        Sets the operations of this ScheduledJobSummary.
        The list of operations this scheduled job needs to perform.
        A scheduled job supports only one operation type, unless it is one of the following:
        * UPDATE_PACKAGES
        * UPDATE_ALL
        * UPDATE_SECURITY
        * UPDATE_BUGFIX
        * UPDATE_ENHANCEMENT
        * UPDATE_OTHER
        * UPDATE_KSPLICE_USERSPACE
        * UPDATE_KSPLICE_KERNEL


        :param operations: The operations of this ScheduledJobSummary.
        :type: list[oci.os_management_hub.models.ScheduledJobOperation]
        """
        self._operations = operations

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this ScheduledJobSummary.
        The current state of the scheduled job.


        :return: The lifecycle_state of this ScheduledJobSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ScheduledJobSummary.
        The current state of the scheduled job.


        :param lifecycle_state: The lifecycle_state of this ScheduledJobSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def is_managed_by_autonomous_linux(self):
        """
        Gets the is_managed_by_autonomous_linux of this ScheduledJobSummary.
        Indicates whether this scheduled job is managed by the Autonomous Linux service.


        :return: The is_managed_by_autonomous_linux of this ScheduledJobSummary.
        :rtype: bool
        """
        return self._is_managed_by_autonomous_linux

    @is_managed_by_autonomous_linux.setter
    def is_managed_by_autonomous_linux(self, is_managed_by_autonomous_linux):
        """
        Sets the is_managed_by_autonomous_linux of this ScheduledJobSummary.
        Indicates whether this scheduled job is managed by the Autonomous Linux service.


        :param is_managed_by_autonomous_linux: The is_managed_by_autonomous_linux of this ScheduledJobSummary.
        :type: bool
        """
        self._is_managed_by_autonomous_linux = is_managed_by_autonomous_linux

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this ScheduledJobSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this ScheduledJobSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ScheduledJobSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this ScheduledJobSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this ScheduledJobSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this ScheduledJobSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ScheduledJobSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this ScheduledJobSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ScheduledJobSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this ScheduledJobSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ScheduledJobSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this ScheduledJobSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def is_restricted(self):
        """
        Gets the is_restricted of this ScheduledJobSummary.
        Indicates if the schedule job has restricted update and deletion capabilities.
        For restricted scheduled jobs, you can update only the timeNextExecution, recurringRule, and tags.


        :return: The is_restricted of this ScheduledJobSummary.
        :rtype: bool
        """
        return self._is_restricted

    @is_restricted.setter
    def is_restricted(self, is_restricted):
        """
        Sets the is_restricted of this ScheduledJobSummary.
        Indicates if the schedule job has restricted update and deletion capabilities.
        For restricted scheduled jobs, you can update only the timeNextExecution, recurringRule, and tags.


        :param is_restricted: The is_restricted of this ScheduledJobSummary.
        :type: bool
        """
        self._is_restricted = is_restricted

    @property
    def retry_intervals(self):
        """
        Gets the retry_intervals of this ScheduledJobSummary.
        The amount of time in minutes to wait until retrying the scheduled job. If set, the service will automatically
        retry a failed scheduled job after the interval. For example, you could set the interval to [2,5,10]. If the
        initial execution of the job fails, the service waits 2 minutes and then retries. If that fails, the service waits
        5 minutes and then retries. If that fails, the service waits 10 minutes and then retries.


        :return: The retry_intervals of this ScheduledJobSummary.
        :rtype: list[int]
        """
        return self._retry_intervals

    @retry_intervals.setter
    def retry_intervals(self, retry_intervals):
        """
        Sets the retry_intervals of this ScheduledJobSummary.
        The amount of time in minutes to wait until retrying the scheduled job. If set, the service will automatically
        retry a failed scheduled job after the interval. For example, you could set the interval to [2,5,10]. If the
        initial execution of the job fails, the service waits 2 minutes and then retries. If that fails, the service waits
        5 minutes and then retries. If that fails, the service waits 10 minutes and then retries.


        :param retry_intervals: The retry_intervals of this ScheduledJobSummary.
        :type: list[int]
        """
        self._retry_intervals = retry_intervals

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
