# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class KernelEventData(object):
    """
    Information about the kernel event.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new KernelEventData object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param content:
            The value to assign to the content property of this KernelEventData.
        :type content: oci.os_management_hub.models.KernelEventContent

        :param count:
            The value to assign to the count property of this KernelEventData.
        :type count: int

        :param event_fingerprint:
            The value to assign to the event_fingerprint property of this KernelEventData.
        :type event_fingerprint: str

        :param reason:
            The value to assign to the reason property of this KernelEventData.
        :type reason: str

        :param time_first_occurred:
            The value to assign to the time_first_occurred property of this KernelEventData.
        :type time_first_occurred: datetime

        :param additional_details:
            The value to assign to the additional_details property of this KernelEventData.
        :type additional_details: oci.os_management_hub.models.KernelEventAdditionalDetails

        """
        self.swagger_types = {
            'content': 'KernelEventContent',
            'count': 'int',
            'event_fingerprint': 'str',
            'reason': 'str',
            'time_first_occurred': 'datetime',
            'additional_details': 'KernelEventAdditionalDetails'
        }

        self.attribute_map = {
            'content': 'content',
            'count': 'count',
            'event_fingerprint': 'eventFingerprint',
            'reason': 'reason',
            'time_first_occurred': 'timeFirstOccurred',
            'additional_details': 'additionalDetails'
        }

        self._content = None
        self._count = None
        self._event_fingerprint = None
        self._reason = None
        self._time_first_occurred = None
        self._additional_details = None

    @property
    def content(self):
        """
        **[Required]** Gets the content of this KernelEventData.

        :return: The content of this KernelEventData.
        :rtype: oci.os_management_hub.models.KernelEventContent
        """
        return self._content

    @content.setter
    def content(self, content):
        """
        Sets the content of this KernelEventData.

        :param content: The content of this KernelEventData.
        :type: oci.os_management_hub.models.KernelEventContent
        """
        self._content = content

    @property
    def count(self):
        """
        **[Required]** Gets the count of this KernelEventData.
        Number of times the event has occurred.


        :return: The count of this KernelEventData.
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count):
        """
        Sets the count of this KernelEventData.
        Number of times the event has occurred.


        :param count: The count of this KernelEventData.
        :type: int
        """
        self._count = count

    @property
    def event_fingerprint(self):
        """
        **[Required]** Gets the event_fingerprint of this KernelEventData.
        Fingerprint of the event.


        :return: The event_fingerprint of this KernelEventData.
        :rtype: str
        """
        return self._event_fingerprint

    @event_fingerprint.setter
    def event_fingerprint(self, event_fingerprint):
        """
        Sets the event_fingerprint of this KernelEventData.
        Fingerprint of the event.


        :param event_fingerprint: The event_fingerprint of this KernelEventData.
        :type: str
        """
        self._event_fingerprint = event_fingerprint

    @property
    def reason(self):
        """
        **[Required]** Gets the reason of this KernelEventData.
        Reason for the event.


        :return: The reason of this KernelEventData.
        :rtype: str
        """
        return self._reason

    @reason.setter
    def reason(self, reason):
        """
        Sets the reason of this KernelEventData.
        Reason for the event.


        :param reason: The reason of this KernelEventData.
        :type: str
        """
        self._reason = reason

    @property
    def time_first_occurred(self):
        """
        **[Required]** Gets the time_first_occurred of this KernelEventData.
        The date and time that the event first occurred.


        :return: The time_first_occurred of this KernelEventData.
        :rtype: datetime
        """
        return self._time_first_occurred

    @time_first_occurred.setter
    def time_first_occurred(self, time_first_occurred):
        """
        Sets the time_first_occurred of this KernelEventData.
        The date and time that the event first occurred.


        :param time_first_occurred: The time_first_occurred of this KernelEventData.
        :type: datetime
        """
        self._time_first_occurred = time_first_occurred

    @property
    def additional_details(self):
        """
        Gets the additional_details of this KernelEventData.

        :return: The additional_details of this KernelEventData.
        :rtype: oci.os_management_hub.models.KernelEventAdditionalDetails
        """
        return self._additional_details

    @additional_details.setter
    def additional_details(self, additional_details):
        """
        Sets the additional_details of this KernelEventData.

        :param additional_details: The additional_details of this KernelEventData.
        :type: oci.os_management_hub.models.KernelEventAdditionalDetails
        """
        self._additional_details = additional_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
