# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630

from .database_configuration_metric_group import DatabaseConfigurationMetricGroup
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExadataCellConfig(DatabaseConfigurationMetricGroup):
    """
    Storage server configuration
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExadataCellConfig object with values from keyword arguments. The default value of the :py:attr:`~oci.opsi.models.ExadataCellConfig.metric_name` attribute
        of this class is ``EXADATA_CELL_CONFIG`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param metric_name:
            The value to assign to the metric_name property of this ExadataCellConfig.
            Allowed values for this property are: "DB_EXTERNAL_PROPERTIES", "DB_EXTERNAL_INSTANCE", "DB_OS_CONFIG_INSTANCE", "DB_PARAMETERS", "DB_CONNECTION_STATUS", "HOST_RESOURCE_ALLOCATION", "ASM_ENTITY", "EXADATA_CELL_CONFIG"
        :type metric_name: str

        :param time_collected:
            The value to assign to the time_collected property of this ExadataCellConfig.
        :type time_collected: datetime

        :param cell_name:
            The value to assign to the cell_name property of this ExadataCellConfig.
        :type cell_name: str

        :param cell_hash:
            The value to assign to the cell_hash property of this ExadataCellConfig.
        :type cell_hash: str

        :param cell_properties:
            The value to assign to the cell_properties property of this ExadataCellConfig.
        :type cell_properties: str

        :param cell_configs:
            The value to assign to the cell_configs property of this ExadataCellConfig.
        :type cell_configs: str

        :param disk_counts:
            The value to assign to the disk_counts property of this ExadataCellConfig.
        :type disk_counts: str

        """
        self.swagger_types = {
            'metric_name': 'str',
            'time_collected': 'datetime',
            'cell_name': 'str',
            'cell_hash': 'str',
            'cell_properties': 'str',
            'cell_configs': 'str',
            'disk_counts': 'str'
        }

        self.attribute_map = {
            'metric_name': 'metricName',
            'time_collected': 'timeCollected',
            'cell_name': 'cellName',
            'cell_hash': 'cellHash',
            'cell_properties': 'cellProperties',
            'cell_configs': 'cellConfigs',
            'disk_counts': 'diskCounts'
        }

        self._metric_name = None
        self._time_collected = None
        self._cell_name = None
        self._cell_hash = None
        self._cell_properties = None
        self._cell_configs = None
        self._disk_counts = None
        self._metric_name = 'EXADATA_CELL_CONFIG'

    @property
    def cell_name(self):
        """
        Gets the cell_name of this ExadataCellConfig.
        Cell name


        :return: The cell_name of this ExadataCellConfig.
        :rtype: str
        """
        return self._cell_name

    @cell_name.setter
    def cell_name(self, cell_name):
        """
        Sets the cell_name of this ExadataCellConfig.
        Cell name


        :param cell_name: The cell_name of this ExadataCellConfig.
        :type: str
        """
        self._cell_name = cell_name

    @property
    def cell_hash(self):
        """
        Gets the cell_hash of this ExadataCellConfig.
        Cell hash


        :return: The cell_hash of this ExadataCellConfig.
        :rtype: str
        """
        return self._cell_hash

    @cell_hash.setter
    def cell_hash(self, cell_hash):
        """
        Sets the cell_hash of this ExadataCellConfig.
        Cell hash


        :param cell_hash: The cell_hash of this ExadataCellConfig.
        :type: str
        """
        self._cell_hash = cell_hash

    @property
    def cell_properties(self):
        """
        Gets the cell_properties of this ExadataCellConfig.
        Cell properties


        :return: The cell_properties of this ExadataCellConfig.
        :rtype: str
        """
        return self._cell_properties

    @cell_properties.setter
    def cell_properties(self, cell_properties):
        """
        Sets the cell_properties of this ExadataCellConfig.
        Cell properties


        :param cell_properties: The cell_properties of this ExadataCellConfig.
        :type: str
        """
        self._cell_properties = cell_properties

    @property
    def cell_configs(self):
        """
        Gets the cell_configs of this ExadataCellConfig.
        Cell configs


        :return: The cell_configs of this ExadataCellConfig.
        :rtype: str
        """
        return self._cell_configs

    @cell_configs.setter
    def cell_configs(self, cell_configs):
        """
        Sets the cell_configs of this ExadataCellConfig.
        Cell configs


        :param cell_configs: The cell_configs of this ExadataCellConfig.
        :type: str
        """
        self._cell_configs = cell_configs

    @property
    def disk_counts(self):
        """
        Gets the disk_counts of this ExadataCellConfig.
        Cell disk counts


        :return: The disk_counts of this ExadataCellConfig.
        :rtype: str
        """
        return self._disk_counts

    @disk_counts.setter
    def disk_counts(self, disk_counts):
        """
        Sets the disk_counts of this ExadataCellConfig.
        Cell disk counts


        :param disk_counts: The disk_counts of this ExadataCellConfig.
        :type: str
        """
        self._disk_counts = disk_counts

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
