# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Fqdns(object):
    """
    The object representing FQDN details formed using prefix and additionalPrefixes.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Fqdns object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param prefix_fqdns:
            The value to assign to the prefix_fqdns property of this Fqdns.
        :type prefix_fqdns: oci.object_storage.models.PrefixFqdns

        :param additional_prefixes_fqdns:
            The value to assign to the additional_prefixes_fqdns property of this Fqdns.
        :type additional_prefixes_fqdns: dict(str, PrefixFqdns)

        """
        self.swagger_types = {
            'prefix_fqdns': 'PrefixFqdns',
            'additional_prefixes_fqdns': 'dict(str, PrefixFqdns)'
        }

        self.attribute_map = {
            'prefix_fqdns': 'prefixFqdns',
            'additional_prefixes_fqdns': 'additionalPrefixesFqdns'
        }

        self._prefix_fqdns = None
        self._additional_prefixes_fqdns = None

    @property
    def prefix_fqdns(self):
        """
        Gets the prefix_fqdns of this Fqdns.

        :return: The prefix_fqdns of this Fqdns.
        :rtype: oci.object_storage.models.PrefixFqdns
        """
        return self._prefix_fqdns

    @prefix_fqdns.setter
    def prefix_fqdns(self, prefix_fqdns):
        """
        Sets the prefix_fqdns of this Fqdns.

        :param prefix_fqdns: The prefix_fqdns of this Fqdns.
        :type: oci.object_storage.models.PrefixFqdns
        """
        self._prefix_fqdns = prefix_fqdns

    @property
    def additional_prefixes_fqdns(self):
        """
        Gets the additional_prefixes_fqdns of this Fqdns.
        An object containing FQDNs formed using additionalPrefixes.


        :return: The additional_prefixes_fqdns of this Fqdns.
        :rtype: dict(str, PrefixFqdns)
        """
        return self._additional_prefixes_fqdns

    @additional_prefixes_fqdns.setter
    def additional_prefixes_fqdns(self, additional_prefixes_fqdns):
        """
        Sets the additional_prefixes_fqdns of this Fqdns.
        An object containing FQDNs formed using additionalPrefixes.


        :param additional_prefixes_fqdns: The additional_prefixes_fqdns of this Fqdns.
        :type: dict(str, PrefixFqdns)
        """
        self._additional_prefixes_fqdns = additional_prefixes_fqdns

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
