# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AccessTargetDetails(object):
    """
    Details of the targets that can be accessed by the private endpoint.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AccessTargetDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param namespace:
            The value to assign to the namespace property of this AccessTargetDetails.
        :type namespace: str

        :param compartment_id:
            The value to assign to the compartment_id property of this AccessTargetDetails.
        :type compartment_id: str

        :param bucket:
            The value to assign to the bucket property of this AccessTargetDetails.
        :type bucket: str

        """
        self.swagger_types = {
            'namespace': 'str',
            'compartment_id': 'str',
            'bucket': 'str'
        }

        self.attribute_map = {
            'namespace': 'namespace',
            'compartment_id': 'compartmentId',
            'bucket': 'bucket'
        }

        self._namespace = None
        self._compartment_id = None
        self._bucket = None

    @property
    def namespace(self):
        """
        **[Required]** Gets the namespace of this AccessTargetDetails.
        The Object Storage namespace which the private endpoint can access. Wildcards ('*') are allowed. If value is '*', it means all namespaces can be accessed. It cannot be a regex.


        :return: The namespace of this AccessTargetDetails.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this AccessTargetDetails.
        The Object Storage namespace which the private endpoint can access. Wildcards ('*') are allowed. If value is '*', it means all namespaces can be accessed. It cannot be a regex.


        :param namespace: The namespace of this AccessTargetDetails.
        :type: str
        """
        self._namespace = namespace

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this AccessTargetDetails.
        The compartment ID which the private endpoint can access. Wildcards ('*') are allowed. If value is '*', it means all compartments in the specified namespace can be accessed. It cannot be a regex.


        :return: The compartment_id of this AccessTargetDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this AccessTargetDetails.
        The compartment ID which the private endpoint can access. Wildcards ('*') are allowed. If value is '*', it means all compartments in the specified namespace can be accessed. It cannot be a regex.


        :param compartment_id: The compartment_id of this AccessTargetDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def bucket(self):
        """
        **[Required]** Gets the bucket of this AccessTargetDetails.
        The name of the bucket. Avoid entering confidential information. Wildcards ('*') are allowed. If value is '*', it means all buckets in the specified namespace and compartment can be accessed. It cannot be a regex.
        Example: my-new-bucket1


        :return: The bucket of this AccessTargetDetails.
        :rtype: str
        """
        return self._bucket

    @bucket.setter
    def bucket(self, bucket):
        """
        Sets the bucket of this AccessTargetDetails.
        The name of the bucket. Avoid entering confidential information. Wildcards ('*') are allowed. If value is '*', it means all buckets in the specified namespace and compartment can be accessed. It cannot be a regex.
        Example: my-new-bucket1


        :param bucket: The bucket of this AccessTargetDetails.
        :type: str
        """
        self._bucket = bucket

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
