# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CopyBackupDetails(object):
    """
    Details required to copy a DB system backup from its source region to a destination region.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CopyBackupDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CopyBackupDetails.
        :type compartment_id: str

        :param description:
            The value to assign to the description property of this CopyBackupDetails.
        :type description: str

        :param display_name:
            The value to assign to the display_name property of this CopyBackupDetails.
        :type display_name: str

        :param source_backup_id:
            The value to assign to the source_backup_id property of this CopyBackupDetails.
        :type source_backup_id: str

        :param source_region:
            The value to assign to the source_region property of this CopyBackupDetails.
        :type source_region: str

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'description': 'str',
            'display_name': 'str',
            'source_backup_id': 'str',
            'source_region': 'str'
        }

        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'description': 'description',
            'display_name': 'displayName',
            'source_backup_id': 'sourceBackupId',
            'source_region': 'sourceRegion'
        }

        self._compartment_id = None
        self._description = None
        self._display_name = None
        self._source_backup_id = None
        self._source_region = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CopyBackupDetails.
        The OCID of the compartment the DB system backup is to be copied to.

        **Note:** The compartment must be the same as the compartment of the DB system backup in the source region.


        :return: The compartment_id of this CopyBackupDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CopyBackupDetails.
        The OCID of the compartment the DB system backup is to be copied to.

        **Note:** The compartment must be the same as the compartment of the DB system backup in the source region.


        :param compartment_id: The compartment_id of this CopyBackupDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def description(self):
        """
        Gets the description of this CopyBackupDetails.
        A user-supplied description for the DB system backup.
        By default, the source backup description will be used.


        :return: The description of this CopyBackupDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CopyBackupDetails.
        A user-supplied description for the DB system backup.
        By default, the source backup description will be used.


        :param description: The description of this CopyBackupDetails.
        :type: str
        """
        self._description = description

    @property
    def display_name(self):
        """
        Gets the display_name of this CopyBackupDetails.
        A user-supplied display name for the DB system backup.
        By default, the source backup display name will be used.


        :return: The display_name of this CopyBackupDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CopyBackupDetails.
        A user-supplied display name for the DB system backup.
        By default, the source backup display name will be used.


        :param display_name: The display_name of this CopyBackupDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def source_backup_id(self):
        """
        **[Required]** Gets the source_backup_id of this CopyBackupDetails.
        The OCID of DB system backup to be copied.


        :return: The source_backup_id of this CopyBackupDetails.
        :rtype: str
        """
        return self._source_backup_id

    @source_backup_id.setter
    def source_backup_id(self, source_backup_id):
        """
        Sets the source_backup_id of this CopyBackupDetails.
        The OCID of DB system backup to be copied.


        :param source_backup_id: The source_backup_id of this CopyBackupDetails.
        :type: str
        """
        self._source_backup_id = source_backup_id

    @property
    def source_region(self):
        """
        **[Required]** Gets the source_region of this CopyBackupDetails.
        The region identifier of the source region where the DB system backup exists.
        For more information, please see `Regions and Availability Domains`__.

        __ https://docs.oracle.com/en-us/iaas/Content/General/Concepts/regions.htm


        :return: The source_region of this CopyBackupDetails.
        :rtype: str
        """
        return self._source_region

    @source_region.setter
    def source_region(self, source_region):
        """
        Sets the source_region of this CopyBackupDetails.
        The region identifier of the source region where the DB system backup exists.
        For more information, please see `Regions and Availability Domains`__.

        __ https://docs.oracle.com/en-us/iaas/Content/General/Concepts/regions.htm


        :param source_region: The source_region of this CopyBackupDetails.
        :type: str
        """
        self._source_region = source_region

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
