# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180401


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AlarmSuppressionSummary(object):
    """
    A summary of properties for the specified alarm suppression.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AlarmSuppressionSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this AlarmSuppressionSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this AlarmSuppressionSummary.
        :type compartment_id: str

        :param alarm_suppression_target:
            The value to assign to the alarm_suppression_target property of this AlarmSuppressionSummary.
        :type alarm_suppression_target: oci.monitoring.models.AlarmSuppressionTarget

        :param level:
            The value to assign to the level property of this AlarmSuppressionSummary.
        :type level: str

        :param suppression_conditions:
            The value to assign to the suppression_conditions property of this AlarmSuppressionSummary.
        :type suppression_conditions: list[oci.monitoring.models.SuppressionCondition]

        :param display_name:
            The value to assign to the display_name property of this AlarmSuppressionSummary.
        :type display_name: str

        :param description:
            The value to assign to the description property of this AlarmSuppressionSummary.
        :type description: str

        :param dimensions:
            The value to assign to the dimensions property of this AlarmSuppressionSummary.
        :type dimensions: dict(str, str)

        :param time_suppress_from:
            The value to assign to the time_suppress_from property of this AlarmSuppressionSummary.
        :type time_suppress_from: datetime

        :param time_suppress_until:
            The value to assign to the time_suppress_until property of this AlarmSuppressionSummary.
        :type time_suppress_until: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this AlarmSuppressionSummary.
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this AlarmSuppressionSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this AlarmSuppressionSummary.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this AlarmSuppressionSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this AlarmSuppressionSummary.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'alarm_suppression_target': 'AlarmSuppressionTarget',
            'level': 'str',
            'suppression_conditions': 'list[SuppressionCondition]',
            'display_name': 'str',
            'description': 'str',
            'dimensions': 'dict(str, str)',
            'time_suppress_from': 'datetime',
            'time_suppress_until': 'datetime',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'alarm_suppression_target': 'alarmSuppressionTarget',
            'level': 'level',
            'suppression_conditions': 'suppressionConditions',
            'display_name': 'displayName',
            'description': 'description',
            'dimensions': 'dimensions',
            'time_suppress_from': 'timeSuppressFrom',
            'time_suppress_until': 'timeSuppressUntil',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._id = None
        self._compartment_id = None
        self._alarm_suppression_target = None
        self._level = None
        self._suppression_conditions = None
        self._display_name = None
        self._description = None
        self._dimensions = None
        self._time_suppress_from = None
        self._time_suppress_until = None
        self._lifecycle_state = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this AlarmSuppressionSummary.
        The `OCID`__ of the alarm suppression.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this AlarmSuppressionSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this AlarmSuppressionSummary.
        The `OCID`__ of the alarm suppression.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this AlarmSuppressionSummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this AlarmSuppressionSummary.
        The `OCID`__ of the compartment containing the alarm suppression.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this AlarmSuppressionSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this AlarmSuppressionSummary.
        The `OCID`__ of the compartment containing the alarm suppression.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this AlarmSuppressionSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def alarm_suppression_target(self):
        """
        **[Required]** Gets the alarm_suppression_target of this AlarmSuppressionSummary.

        :return: The alarm_suppression_target of this AlarmSuppressionSummary.
        :rtype: oci.monitoring.models.AlarmSuppressionTarget
        """
        return self._alarm_suppression_target

    @alarm_suppression_target.setter
    def alarm_suppression_target(self, alarm_suppression_target):
        """
        Sets the alarm_suppression_target of this AlarmSuppressionSummary.

        :param alarm_suppression_target: The alarm_suppression_target of this AlarmSuppressionSummary.
        :type: oci.monitoring.models.AlarmSuppressionTarget
        """
        self._alarm_suppression_target = alarm_suppression_target

    @property
    def level(self):
        """
        **[Required]** Gets the level of this AlarmSuppressionSummary.
        The level of this alarm suppression.
        `ALARM` indicates a suppression of the entire alarm, regardless of dimension.
        `DIMENSION` indicates a suppression configured for specified dimensions.


        :return: The level of this AlarmSuppressionSummary.
        :rtype: str
        """
        return self._level

    @level.setter
    def level(self, level):
        """
        Sets the level of this AlarmSuppressionSummary.
        The level of this alarm suppression.
        `ALARM` indicates a suppression of the entire alarm, regardless of dimension.
        `DIMENSION` indicates a suppression configured for specified dimensions.


        :param level: The level of this AlarmSuppressionSummary.
        :type: str
        """
        self._level = level

    @property
    def suppression_conditions(self):
        """
        Gets the suppression_conditions of this AlarmSuppressionSummary.
        Array of all preconditions for alarm suppression.
        Example: `[{
          conditionType: \"RECURRENCE\",
          suppressionRecurrence: \"FRQ=DAILY;BYHOUR=10\",
          suppressionDuration: \"PT1H\"
        }]`


        :return: The suppression_conditions of this AlarmSuppressionSummary.
        :rtype: list[oci.monitoring.models.SuppressionCondition]
        """
        return self._suppression_conditions

    @suppression_conditions.setter
    def suppression_conditions(self, suppression_conditions):
        """
        Sets the suppression_conditions of this AlarmSuppressionSummary.
        Array of all preconditions for alarm suppression.
        Example: `[{
          conditionType: \"RECURRENCE\",
          suppressionRecurrence: \"FRQ=DAILY;BYHOUR=10\",
          suppressionDuration: \"PT1H\"
        }]`


        :param suppression_conditions: The suppression_conditions of this AlarmSuppressionSummary.
        :type: list[oci.monitoring.models.SuppressionCondition]
        """
        self._suppression_conditions = suppression_conditions

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this AlarmSuppressionSummary.
        A user-friendly name for the alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.


        :return: The display_name of this AlarmSuppressionSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this AlarmSuppressionSummary.
        A user-friendly name for the alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.


        :param display_name: The display_name of this AlarmSuppressionSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this AlarmSuppressionSummary.
        Human-readable reason for this alarm suppression.
        It does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Oracle recommends including tracking information for the event or associated work,
        such as a ticket number.

        Example: `Planned outage due to change IT-1234.`


        :return: The description of this AlarmSuppressionSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this AlarmSuppressionSummary.
        Human-readable reason for this alarm suppression.
        It does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Oracle recommends including tracking information for the event or associated work,
        such as a ticket number.

        Example: `Planned outage due to change IT-1234.`


        :param description: The description of this AlarmSuppressionSummary.
        :type: str
        """
        self._description = description

    @property
    def dimensions(self):
        """
        Gets the dimensions of this AlarmSuppressionSummary.
        Configured dimension filter for suppressing alarm state entries that include the set of specified dimension key-value pairs.

        Example: `{\"resourceId\": \"ocid1.instance.region1.phx.exampleuniqueID\"}`


        :return: The dimensions of this AlarmSuppressionSummary.
        :rtype: dict(str, str)
        """
        return self._dimensions

    @dimensions.setter
    def dimensions(self, dimensions):
        """
        Sets the dimensions of this AlarmSuppressionSummary.
        Configured dimension filter for suppressing alarm state entries that include the set of specified dimension key-value pairs.

        Example: `{\"resourceId\": \"ocid1.instance.region1.phx.exampleuniqueID\"}`


        :param dimensions: The dimensions of this AlarmSuppressionSummary.
        :type: dict(str, str)
        """
        self._dimensions = dimensions

    @property
    def time_suppress_from(self):
        """
        **[Required]** Gets the time_suppress_from of this AlarmSuppressionSummary.
        The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.

        Example: `2023-02-01T01:02:29.600Z`


        :return: The time_suppress_from of this AlarmSuppressionSummary.
        :rtype: datetime
        """
        return self._time_suppress_from

    @time_suppress_from.setter
    def time_suppress_from(self, time_suppress_from):
        """
        Sets the time_suppress_from of this AlarmSuppressionSummary.
        The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.

        Example: `2023-02-01T01:02:29.600Z`


        :param time_suppress_from: The time_suppress_from of this AlarmSuppressionSummary.
        :type: datetime
        """
        self._time_suppress_from = time_suppress_from

    @property
    def time_suppress_until(self):
        """
        **[Required]** Gets the time_suppress_until of this AlarmSuppressionSummary.
        The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.

        Example: `2023-02-01T02:02:29.600Z`


        :return: The time_suppress_until of this AlarmSuppressionSummary.
        :rtype: datetime
        """
        return self._time_suppress_until

    @time_suppress_until.setter
    def time_suppress_until(self, time_suppress_until):
        """
        Sets the time_suppress_until of this AlarmSuppressionSummary.
        The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.

        Example: `2023-02-01T02:02:29.600Z`


        :param time_suppress_until: The time_suppress_until of this AlarmSuppressionSummary.
        :type: datetime
        """
        self._time_suppress_until = time_suppress_until

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this AlarmSuppressionSummary.
        The current lifecycle state of the alarm suppression.

        Example: `DELETED`


        :return: The lifecycle_state of this AlarmSuppressionSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this AlarmSuppressionSummary.
        The current lifecycle state of the alarm suppression.

        Example: `DELETED`


        :param lifecycle_state: The lifecycle_state of this AlarmSuppressionSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this AlarmSuppressionSummary.
        The date and time the alarm suppression was created. Format defined by RFC3339.

        Example: `2023-02-01T01:02:29.600Z`


        :return: The time_created of this AlarmSuppressionSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this AlarmSuppressionSummary.
        The date and time the alarm suppression was created. Format defined by RFC3339.

        Example: `2023-02-01T01:02:29.600Z`


        :param time_created: The time_created of this AlarmSuppressionSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this AlarmSuppressionSummary.
        The date and time the alarm suppression was last updated (deleted). Format defined by RFC3339.

        Example: `2023-02-03T01:02:29.600Z`


        :return: The time_updated of this AlarmSuppressionSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this AlarmSuppressionSummary.
        The date and time the alarm suppression was last updated (deleted). Format defined by RFC3339.

        Example: `2023-02-03T01:02:29.600Z`


        :param time_updated: The time_updated of this AlarmSuppressionSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this AlarmSuppressionSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this AlarmSuppressionSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this AlarmSuppressionSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this AlarmSuppressionSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this AlarmSuppressionSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this AlarmSuppressionSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this AlarmSuppressionSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this AlarmSuppressionSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
