# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180401

from .alarm_suppression_target import AlarmSuppressionTarget
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AlarmSuppressionCompartmentTarget(AlarmSuppressionTarget):
    """
    The compartment target of the alarm suppression.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AlarmSuppressionCompartmentTarget object with values from keyword arguments. The default value of the :py:attr:`~oci.monitoring.models.AlarmSuppressionCompartmentTarget.target_type` attribute
        of this class is ``COMPARTMENT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param target_type:
            The value to assign to the target_type property of this AlarmSuppressionCompartmentTarget.
            Allowed values for this property are: "ALARM", "COMPARTMENT"
        :type target_type: str

        :param compartment_id:
            The value to assign to the compartment_id property of this AlarmSuppressionCompartmentTarget.
        :type compartment_id: str

        :param compartment_id_in_subtree:
            The value to assign to the compartment_id_in_subtree property of this AlarmSuppressionCompartmentTarget.
        :type compartment_id_in_subtree: bool

        """
        self.swagger_types = {
            'target_type': 'str',
            'compartment_id': 'str',
            'compartment_id_in_subtree': 'bool'
        }

        self.attribute_map = {
            'target_type': 'targetType',
            'compartment_id': 'compartmentId',
            'compartment_id_in_subtree': 'compartmentIdInSubtree'
        }

        self._target_type = None
        self._compartment_id = None
        self._compartment_id_in_subtree = None
        self._target_type = 'COMPARTMENT'

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this AlarmSuppressionCompartmentTarget.
        The `OCID`__ of the compartment or tenancy that is the
        target of the alarm suppression.
        Example: `ocid1.compartment.oc1..exampleuniqueID`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this AlarmSuppressionCompartmentTarget.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this AlarmSuppressionCompartmentTarget.
        The `OCID`__ of the compartment or tenancy that is the
        target of the alarm suppression.
        Example: `ocid1.compartment.oc1..exampleuniqueID`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this AlarmSuppressionCompartmentTarget.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def compartment_id_in_subtree(self):
        """
        Gets the compartment_id_in_subtree of this AlarmSuppressionCompartmentTarget.
        When true, the alarm suppression targets all alarms under all compartments and subcompartments of
        the tenancy specified. The parameter can only be set to true when compartmentId is the tenancy OCID
        (the tenancy is the root compartment). When false, the alarm suppression targets only the alarms under
        the specified compartment.


        :return: The compartment_id_in_subtree of this AlarmSuppressionCompartmentTarget.
        :rtype: bool
        """
        return self._compartment_id_in_subtree

    @compartment_id_in_subtree.setter
    def compartment_id_in_subtree(self, compartment_id_in_subtree):
        """
        Sets the compartment_id_in_subtree of this AlarmSuppressionCompartmentTarget.
        When true, the alarm suppression targets all alarms under all compartments and subcompartments of
        the tenancy specified. The parameter can only be set to true when compartmentId is the tenancy OCID
        (the tenancy is the root compartment). When false, the alarm suppression targets only the alarms under
        the specified compartment.


        :param compartment_id_in_subtree: The compartment_id_in_subtree of this AlarmSuppressionCompartmentTarget.
        :type: bool
        """
        self._compartment_id_in_subtree = compartment_id_in_subtree

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
