# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200531

from .unified_agent_monitoring_application_configuration_details import UnifiedAgentMonitoringApplicationConfigurationDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UnifiedAgentOpenmetricsTailConfigurationDetails(UnifiedAgentMonitoringApplicationConfigurationDetails):
    """
    Unified Agent Openmetrics tail configuration object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UnifiedAgentOpenmetricsTailConfigurationDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.logging.models.UnifiedAgentOpenmetricsTailConfigurationDetails.source_type` attribute
        of this class is ``TAIL`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_type:
            The value to assign to the source_type property of this UnifiedAgentOpenmetricsTailConfigurationDetails.
            Allowed values for this property are: "KUBERNETES", "TAIL", "URL"
        :type source_type: str

        :param sources:
            The value to assign to the sources property of this UnifiedAgentOpenmetricsTailConfigurationDetails.
        :type sources: list[oci.logging.models.UnifiedAgentTailLogSource]

        :param destination:
            The value to assign to the destination property of this UnifiedAgentOpenmetricsTailConfigurationDetails.
        :type destination: oci.logging.models.UnifiedAgentMonitoringDestination

        """
        self.swagger_types = {
            'source_type': 'str',
            'sources': 'list[UnifiedAgentTailLogSource]',
            'destination': 'UnifiedAgentMonitoringDestination'
        }

        self.attribute_map = {
            'source_type': 'sourceType',
            'sources': 'sources',
            'destination': 'destination'
        }

        self._source_type = None
        self._sources = None
        self._destination = None
        self._source_type = 'TAIL'

    @property
    def sources(self):
        """
        **[Required]** Gets the sources of this UnifiedAgentOpenmetricsTailConfigurationDetails.
        Tail log source objects.


        :return: The sources of this UnifiedAgentOpenmetricsTailConfigurationDetails.
        :rtype: list[oci.logging.models.UnifiedAgentTailLogSource]
        """
        return self._sources

    @sources.setter
    def sources(self, sources):
        """
        Sets the sources of this UnifiedAgentOpenmetricsTailConfigurationDetails.
        Tail log source objects.


        :param sources: The sources of this UnifiedAgentOpenmetricsTailConfigurationDetails.
        :type: list[oci.logging.models.UnifiedAgentTailLogSource]
        """
        self._sources = sources

    @property
    def destination(self):
        """
        **[Required]** Gets the destination of this UnifiedAgentOpenmetricsTailConfigurationDetails.

        :return: The destination of this UnifiedAgentOpenmetricsTailConfigurationDetails.
        :rtype: oci.logging.models.UnifiedAgentMonitoringDestination
        """
        return self._destination

    @destination.setter
    def destination(self, destination):
        """
        Sets the destination of this UnifiedAgentOpenmetricsTailConfigurationDetails.

        :param destination: The destination of this UnifiedAgentOpenmetricsTailConfigurationDetails.
        :type: oci.logging.models.UnifiedAgentMonitoringDestination
        """
        self._destination = destination

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
