# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200531

from .unified_agent_logging_filter import UnifiedAgentLoggingFilter
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UnifiedAgentLoggingRecordTransformerFilter(UnifiedAgentLoggingFilter):
    """
    Logging record transformer filter object mutates/transforms logs.
    Ref: https://docs.fluentd.org/filter/record_transformer
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UnifiedAgentLoggingRecordTransformerFilter object with values from keyword arguments. The default value of the :py:attr:`~oci.logging.models.UnifiedAgentLoggingRecordTransformerFilter.filter_type` attribute
        of this class is ``RECORD_TRANSFORMER_FILTER`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this UnifiedAgentLoggingRecordTransformerFilter.
        :type name: str

        :param filter_type:
            The value to assign to the filter_type property of this UnifiedAgentLoggingRecordTransformerFilter.
            Allowed values for this property are: "PARSER_FILTER", "GREP_FILTER", "RECORD_TRANSFORMER_FILTER", "CUSTOM_FILTER"
        :type filter_type: str

        :param record_list:
            The value to assign to the record_list property of this UnifiedAgentLoggingRecordTransformerFilter.
        :type record_list: list[oci.logging.models.RecordTransformerPair]

        :param is_ruby_enabled:
            The value to assign to the is_ruby_enabled property of this UnifiedAgentLoggingRecordTransformerFilter.
        :type is_ruby_enabled: bool

        :param is_auto_typecast_enabled:
            The value to assign to the is_auto_typecast_enabled property of this UnifiedAgentLoggingRecordTransformerFilter.
        :type is_auto_typecast_enabled: bool

        :param is_renew_record_enabled:
            The value to assign to the is_renew_record_enabled property of this UnifiedAgentLoggingRecordTransformerFilter.
        :type is_renew_record_enabled: bool

        :param renew_time_key:
            The value to assign to the renew_time_key property of this UnifiedAgentLoggingRecordTransformerFilter.
        :type renew_time_key: str

        :param keep_keys:
            The value to assign to the keep_keys property of this UnifiedAgentLoggingRecordTransformerFilter.
        :type keep_keys: list[str]

        :param remove_keys:
            The value to assign to the remove_keys property of this UnifiedAgentLoggingRecordTransformerFilter.
        :type remove_keys: list[str]

        """
        self.swagger_types = {
            'name': 'str',
            'filter_type': 'str',
            'record_list': 'list[RecordTransformerPair]',
            'is_ruby_enabled': 'bool',
            'is_auto_typecast_enabled': 'bool',
            'is_renew_record_enabled': 'bool',
            'renew_time_key': 'str',
            'keep_keys': 'list[str]',
            'remove_keys': 'list[str]'
        }

        self.attribute_map = {
            'name': 'name',
            'filter_type': 'filterType',
            'record_list': 'recordList',
            'is_ruby_enabled': 'isRubyEnabled',
            'is_auto_typecast_enabled': 'isAutoTypecastEnabled',
            'is_renew_record_enabled': 'isRenewRecordEnabled',
            'renew_time_key': 'renewTimeKey',
            'keep_keys': 'keepKeys',
            'remove_keys': 'removeKeys'
        }

        self._name = None
        self._filter_type = None
        self._record_list = None
        self._is_ruby_enabled = None
        self._is_auto_typecast_enabled = None
        self._is_renew_record_enabled = None
        self._renew_time_key = None
        self._keep_keys = None
        self._remove_keys = None
        self._filter_type = 'RECORD_TRANSFORMER_FILTER'

    @property
    def record_list(self):
        """
        **[Required]** Gets the record_list of this UnifiedAgentLoggingRecordTransformerFilter.
        Add new key-value pairs in logs


        :return: The record_list of this UnifiedAgentLoggingRecordTransformerFilter.
        :rtype: list[oci.logging.models.RecordTransformerPair]
        """
        return self._record_list

    @record_list.setter
    def record_list(self, record_list):
        """
        Sets the record_list of this UnifiedAgentLoggingRecordTransformerFilter.
        Add new key-value pairs in logs


        :param record_list: The record_list of this UnifiedAgentLoggingRecordTransformerFilter.
        :type: list[oci.logging.models.RecordTransformerPair]
        """
        self._record_list = record_list

    @property
    def is_ruby_enabled(self):
        """
        Gets the is_ruby_enabled of this UnifiedAgentLoggingRecordTransformerFilter.
        When set to true, the full Ruby syntax is enabled in the ${} expression.


        :return: The is_ruby_enabled of this UnifiedAgentLoggingRecordTransformerFilter.
        :rtype: bool
        """
        return self._is_ruby_enabled

    @is_ruby_enabled.setter
    def is_ruby_enabled(self, is_ruby_enabled):
        """
        Sets the is_ruby_enabled of this UnifiedAgentLoggingRecordTransformerFilter.
        When set to true, the full Ruby syntax is enabled in the ${} expression.


        :param is_ruby_enabled: The is_ruby_enabled of this UnifiedAgentLoggingRecordTransformerFilter.
        :type: bool
        """
        self._is_ruby_enabled = is_ruby_enabled

    @property
    def is_auto_typecast_enabled(self):
        """
        Gets the is_auto_typecast_enabled of this UnifiedAgentLoggingRecordTransformerFilter.
        If true, automatically casts the field types.


        :return: The is_auto_typecast_enabled of this UnifiedAgentLoggingRecordTransformerFilter.
        :rtype: bool
        """
        return self._is_auto_typecast_enabled

    @is_auto_typecast_enabled.setter
    def is_auto_typecast_enabled(self, is_auto_typecast_enabled):
        """
        Sets the is_auto_typecast_enabled of this UnifiedAgentLoggingRecordTransformerFilter.
        If true, automatically casts the field types.


        :param is_auto_typecast_enabled: The is_auto_typecast_enabled of this UnifiedAgentLoggingRecordTransformerFilter.
        :type: bool
        """
        self._is_auto_typecast_enabled = is_auto_typecast_enabled

    @property
    def is_renew_record_enabled(self):
        """
        Gets the is_renew_record_enabled of this UnifiedAgentLoggingRecordTransformerFilter.
        If true, it modifies a new empty hash


        :return: The is_renew_record_enabled of this UnifiedAgentLoggingRecordTransformerFilter.
        :rtype: bool
        """
        return self._is_renew_record_enabled

    @is_renew_record_enabled.setter
    def is_renew_record_enabled(self, is_renew_record_enabled):
        """
        Sets the is_renew_record_enabled of this UnifiedAgentLoggingRecordTransformerFilter.
        If true, it modifies a new empty hash


        :param is_renew_record_enabled: The is_renew_record_enabled of this UnifiedAgentLoggingRecordTransformerFilter.
        :type: bool
        """
        self._is_renew_record_enabled = is_renew_record_enabled

    @property
    def renew_time_key(self):
        """
        Gets the renew_time_key of this UnifiedAgentLoggingRecordTransformerFilter.
        Overwrites the time of logs with this value, this value must be a Unix timestamp.


        :return: The renew_time_key of this UnifiedAgentLoggingRecordTransformerFilter.
        :rtype: str
        """
        return self._renew_time_key

    @renew_time_key.setter
    def renew_time_key(self, renew_time_key):
        """
        Sets the renew_time_key of this UnifiedAgentLoggingRecordTransformerFilter.
        Overwrites the time of logs with this value, this value must be a Unix timestamp.


        :param renew_time_key: The renew_time_key of this UnifiedAgentLoggingRecordTransformerFilter.
        :type: str
        """
        self._renew_time_key = renew_time_key

    @property
    def keep_keys(self):
        """
        Gets the keep_keys of this UnifiedAgentLoggingRecordTransformerFilter.
        A list of keys to keep. Only relevant if isRenewRecordEnabled is set to true


        :return: The keep_keys of this UnifiedAgentLoggingRecordTransformerFilter.
        :rtype: list[str]
        """
        return self._keep_keys

    @keep_keys.setter
    def keep_keys(self, keep_keys):
        """
        Sets the keep_keys of this UnifiedAgentLoggingRecordTransformerFilter.
        A list of keys to keep. Only relevant if isRenewRecordEnabled is set to true


        :param keep_keys: The keep_keys of this UnifiedAgentLoggingRecordTransformerFilter.
        :type: list[str]
        """
        self._keep_keys = keep_keys

    @property
    def remove_keys(self):
        """
        Gets the remove_keys of this UnifiedAgentLoggingRecordTransformerFilter.
        A list of keys to delete


        :return: The remove_keys of this UnifiedAgentLoggingRecordTransformerFilter.
        :rtype: list[str]
        """
        return self._remove_keys

    @remove_keys.setter
    def remove_keys(self, remove_keys):
        """
        Sets the remove_keys of this UnifiedAgentLoggingRecordTransformerFilter.
        A list of keys to delete


        :param remove_keys: The remove_keys of this UnifiedAgentLoggingRecordTransformerFilter.
        :type: list[str]
        """
        self._remove_keys = remove_keys

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
